# viewTraceInfo {#viewtraceinfo}

**Parent topic:**[SQL Trace](../../../Programming/SQLStatements/SQLTrace/SQLTrace.md)

## Syntax {#syntax}

viewTraceInfo\(traceId, \[isTreeView=true\]\)

## Arguments {#arguments}

**traceId** is a STRING indicating the ID of a trace. Get the trace ID of a script with [getTraces](getTraces.md).

**isTreeView** is a Boolean indicating whether to display the tracing information in tree view. The default value is true. Otherwise, the information is displayed in plain list.

## Details {#details}

Display the tracing information of a trace. Return a table with the following columns:

-   \[when *isTreeView* = true\] *tree*: the execution process of the script in tree structure where each tree node is a span \(the primary building block of a distributed trace, representing an individual unit of work done in a distributed system\).

-   \[when *isTreeView* = false\] *name*: the name of the spans of the trace.

-   *script*: the specific script executed by each span.

-   *startTime*: the timestamp \(in nanoseconds\) at which the span execution started.

-   *timeElapsed*: the duration of the span execution in miliseconds

-   *reference*: the relationship between the current span and its parent span. There are three types of references:

    -   *Root*: the root node of the trace. It indicates that the server received the client request. Rood node does not have a parent.

    -   *ChildOf*: indicates that the parent span depends on the result of the current span. This reference type indicates that the current span is executed synchronously.

    -   *FollowsFrom*: indicates that the current span merely follows from its parent span in a causal sense and the parent span does not depend on the result of its child. This reference type indicates that the child span is executed asynchronously \(e.g., added to a queue for execution, network requests, etc.\).

    -   *node*: the alias of the node on which the span is executed.

    -   *thread*: the thread ID of the span.


Common span operation reference:

|Operation|Description|
|---------|-----------|
|Worker::run|Upon receiving a request, the server adds it to the queue for a worker thread to process it. *x* is a positive integer with a value range of \[0, 6\].|
|Tokenizer::tokenize|Perform lexical analysis on the script contained in the request to get a stream of lexical tokens for subsequent syntactic parsing.|
|Parser::parse|Perform syntactic parsing on the script in the request to get executable statements.|
|Statement::execute|A line of executable statement in the script.|
|SQLQueryImp::getReference|Execute SQL query.|
|SQLQueryImp::partitionedCall|Query a partitioned table. The system will break down the query into tasks and send them to the corresponding data nodes for execution. Usually seen in distributed queries.|
|SQLQueryImp::simpleCall|Perform a simple query that doesn't contain operations such as "group by", "context by", and "croup by". Usually seen in queries on an in-memory table.|
|SQLQueryImp::basicCall|Read data from the storage engine.|
|StaticStageExecutor::execute\[probing\]|The probing process before the execution of a distributed query. A query submitted by the client will be broken down into multiple tasks. Some of the tasks are executed on the local node while others are sent to other nodes based on where the associated data is stored. When there are a large number of tasks to be sent to a remote node, the system will send them in groups.During the probing phase, the system sends one task to a remote node to detect the memory usage of the task result, thus estimating the total memory usage of the query result. If the total memory usage exceeds memLimitOfQueryResult, an exception is thrown; otherwise, the system determines the number of tasks per group to send to each remote node based on the memory usage of the single task result and the specified memLimiteOfTaskGroupResult.|
|StaticStageExecutor::execute\[remote\]|The process of executing tasks on a remote node, including network calls and remote executions.|
|StaticStageExecutor::execute\[local\]|The process of local execution by the worker thread.|
|GOContainer::addRemoteTask|Send a task to a remote node. Note that this operation only involves the sending process and does not include the execution on the remote node or the node response.|
|TableJoiner::getReference|Perform a table join operation|
|GroupByEngine::getReference|Perform a "group by" operation|
|ContextByEngine::getReference|Perform a "context by" operation|
|PivotByEngine::getReference|Perform a "pivot by" operation|
|PartitionedPersistentTable::spillToDisk|Move data of a persisted partitioned table from memory to disk|
|PipelinedJoinTask::getReference|Perform a join pipeline operation|
|StaticStageExecutor::execute\[batch\]|Execute batch jobs|
|UniversalTableJoinImp::executeJoinPipeline|Perform a join pipeline operation on multiple tables|
|UniversalTableJoinImp::getReference|Perform a query on multiple tables|

## Examples {#examples}

```
viewTraceInfo("c87ffe02-0c93-1db0-8e4f-b5416cce0207", true);
```

|tree|script|startTime|timeElapsed|reference|node|thread|
|----|------|---------|-----------|---------|----|------|
|receiving request||2023.11.27 07:53:37.564128355|50|Root|local7270|41,472|
|└── Worker&lt;0&gt;::run||2023.11.27 07:53:37.565859643|109,969|FollowsFrom|local7270|41,457|
|├── Tokenizer::tokenize||2023.11.27 07:53:37.566078288|61|ChildOf|local7270|41,457|
|├── Parser::parse||2023.11.27 07:53:37.566161146|429|ChildOf|local7270|41,457|
|└── Statement::execute|t1 = select ID,col1,col2,ratio1,ratio2,col1 \* ratio1 as col1\_mul,col2 \* ratio2 as col2\_mul from ej\(loadTable\("dfs://TSDBdemo", "data"\),temp,"ID","securityId"\) where ID in "tag" + string\(1 .. 19\)|2023.11.27 07:53:37.566651394|109,110|ChildOf|local7270|41,457|
|└── SQLQueryImp::getReference|select ID,col1,col2,ratio1,ratio2,col1 \* ratio1 as col1\_mul,col2 \* ratio2 as col2\_mul from ej\(loadTable\("dfs://TSDBdemo", "data"\),temp,"ID","securityId"\) where ID in "tag" + string\(1 .. 19\)|2023.11.27 07:53:37.566691562|109,031|ChildOf|local7270|41,457|
|└── SQLQueryImp::getReference|select ID,col1,col2,ratio1,ratio2,col1 \* ratio1 as col1\_mul,col2 \* ratio2 as col2\_mul from ej\(data,tempb035e530587f0000,"ID","securityId"\) where ID in "tag" + string\(1 .. 19\)|2023.11.27 07:53:37.567047904|108,611|ChildOf|local7270|41,457|
|└── SQLQueryImp::partitionedCall||2023.11.27 07:53:37.568467496|107,166|ChildOf|local7270|41,457|
|└── SQLQueryImp::executeDistributedTasks||2023.11.27 07:53:37.569360522|105,751|ChildOf|local7270|41,457|
|├── StaticStageExecutor::execute||2023.11.27 07:53:37.569425993|103,402|ChildOf|local7270|41,457|
|│ ├── StaticStageExecutor::execute\[probing\]||2023.11.27 07:53:37.569446501|5|ChildOf|local7270|41,457|
|│ ├── StaticStageExecutor::execute\[localWorker\]||2023.11.27 07:53:37.569472069|16,530|ChildOf|local7270|41,457|
|│ ├── StaticStageExecutor::execute\[remote\]||2023.11.27 07:53:37.569491542|16,503|ChildOf|local7270|41,457|
|│ └── StaticStageExecutor::execute\[local\]||2023.11.27 07:53:37.569512416|102,990|ChildOf|local7270|41,457|
|│ ├── SQLQueryImp::getReference|select \[147467\] ID,col1,col2,ratio1,ratio2,col1 \* ratio1 as col1\_mul,col2 \* ratio2 as col2\_mul from ej\(data,tempb035e530587f0000,"ID","securityId"\) where ID in "tag" + string\(1 .. 19\) \[partition = /TSDBdemo/20231112/Key0/x5\]|2023.11.27 07:53:37.586062823|10,658|ChildOf|local7270|41,457|
|│ │ └── SQLQueryImp::basicCall||2023.11.27 07:53:37.586079488|10,611|ChildOf|local7270|41,457|
|│ │ └── TableJoiner::getReference|ej\(data,tempb035e530587f0000,"ID","securityId"\)|2023.11.27 07:53:37.586099380|10,465|ChildOf|local7270|41,457|
|│ │ └── TableJoinerImp::getReference|ej\(data,tempb035e530587f0000,"ID","securityId"\)|2023.11.27 07:53:37.586123907|10,374|ChildOf|local7270|41,457|
|│ ├── SQLQueryImp::getReference||2023.11.27 07:53:37.596826822|16,607|ChildOf|local7270|41,457|
|│ │ └── SQLQueryImp::basicCall||2023.11.27 07:53:37.596858895|16,529|ChildOf|local7270|41,457|
|│ │ └── TableJoiner::getReference||2023.11.27 07:53:37.596885332|16,342|ChildOf|local7270|41,457|
|│ │ └── TableJoinerImp::getReference||2023.11.27 07:53:37.596920858|14,428|ChildOf|local7270|41,457|
|│ ├── SQLQueryImp::getReference||2023.11.27 07:53:37.613520106|5,338|ChildOf|local7270|41,457|
|│ │ └── SQLQueryImp::basicCall||2023.11.27 07:53:37.613543452|5,251|ChildOf|local7270|41,457|
|│ │ └── TableJoiner::getReference||2023.11.27 07:53:37.613565397|5,127|ChildOf|local7270|41,457|
|│ │ └── TableJoinerImp::getReference||2023.11.27 07:53:37.613591427|5,067|ChildOf|local7270|41,457|
|│ ├── SQLQueryImp::getReference||2023.11.27 07:53:37.618933658|13,263|ChildOf|local7270|41,457|
|│ │ └── SQLQueryImp::basicCall||2023.11.27 07:53:37.618955493|13,198|ChildOf|local7270|41,457|
|│ │ └── TableJoiner::getReference||2023.11.27 07:53:37.618973938|10,390|ChildOf|local7270|41,457|
|│ │ └── TableJoinerImp::getReference||2023.11.27 07:53:37.618998447|10,167|ChildOf|local7270|41,457|
|│ ├── SQLQueryImp::getReference||2023.11.27 07:53:37.632284783|11,046|ChildOf|local7270|41,457|
|│ │ └── SQLQueryImp::basicCall||2023.11.27 07:53:37.632305236|11,022|ChildOf|local7270|41,457|
|│ │ └── TableJoiner::getReference||2023.11.27 07:53:37.632330014|10,864|ChildOf|local7270|41,457|
|│ │ └── TableJoinerImp::getReference||2023.11.27 07:53:37.632352650|7,955|ChildOf|local7270|41,457|
|│ ├── SQLQueryImp::getReference||2023.11.27 07:53:37.643674730|11,336|ChildOf|local7270|41,457|
|│ │ └── SQLQueryImp::basicCall||2023.11.27 07:53:37.643693926|11,313|ChildOf|local7270|41,457|
|│ │ └── TableJoiner::getReference||2023.11.27 07:53:37.643714493|11,168|ChildOf|local7270|41,457|
|│ │ └── TableJoinerImp::getReference||2023.11.27 07:53:37.643737539|8,961|ChildOf|local7270|41,457|
|│ ├── SQLQueryImp::getReference|select \[147467\] ID,col1,col2,ratio1,ratio2,col1 \* ratio1 as col1\_mul,col2 \* ratio2 as col2\_mul from ej\(data,tempb035e530587f0000,"ID","securityId"\) where ID in "tag" + string\(1 .. 19\) \[partition = /TSDBdemo/20231120/Key0/x5\]|2023.11.27 07:53:37.655067979|10,913|ChildOf|local7270|41,457|
|│ │ └── SQLQueryImp::basicCall||2023.11.27 07:53:37.655087126|10,874|ChildOf|local7270|41,457|
|│ │ └── TableJoiner::getReference||2023.11.27 07:53:37.655294579|10,551|ChildOf|local7270|41,457|
|│ │ └── TableJoinerImp::getReference||2023.11.27 07:53:37.655322871|10,413|ChildOf|local7270|41,457|
|│ └── SQLQueryImp::getReference||2023.11.27 07:53:37.666074996|6,352|ChildOf|local7270|41,457|
|│ └── SQLQueryImp::basicCall||2023.11.27 07:53:37.666094885|6,317|ChildOf|local7270|41,457|
|│ └── TableJoiner::getReference||2023.11.27 07:53:37.666112965|6,188|ChildOf|local7270|41,457|
|│ └── TableJoinerImp::getReference||2023.11.27 07:53:37.666133582|6,111|ChildOf|local7270|41,457|
|├── SQLQueryImp::executeDistributedTasks\[firstNonEmptyTask.getValue\]||2023.11.27 07:53:37.672891073|102|ChildOf|local7270|41,457|
|├── SQLQueryImp::executeDistributedTasks\[collectFinalColumns\]||2023.11.27 07:53:37.673014087|72|ChildOf|local7270|41,457|
|└── SQLQueryImp::executeDistributedTasks\[concatenateColumns\]||2023.11.27 07:53:37.673112499|1,621|ChildOf|local7270|41,457|

