# use {#use}

To use a module, use the "use" keyword followed by the module names.

```
use example::ch9
```

After this, we can call all the functions defined in the module. Since different modules can define functions with the same name, the following are the rules to disambiguate function calls.

\(1\) Function names are qualified with the module namespace.

-   Simply refer to the function defined in that module.
-   All DolphinDB built-in functions are defined in the root module ::. For example, ::add\(3,4\) means the add function in the root module.

\(2\) Namespace is not specified.

-   If the current module defines the function, it refers to the function defined in the current module.
-   If one and only one imported module contains the function, it refers to the function defined in that module.
-   If two or more imported modules contain the function, throw an exception.
-   If no imported module contains the function, search in the root namespace. If the root namespace does not contain the function, throw an exception.

Before version 2.00.12, the `use` statement only supported loading *.dos* files. As of 2.00.12, `use` can be used to load *.dos* and *.dom* files.

-   If there are a .dos and a *.dom* file with the same name in the directory, the .dos file will be loaded.

-   If a *.dom* file has dependencies on other files, these files will be loaded together.

-   To update a file that has been loaded with `use`, call `clearCachedModules` to clear the cache first.

-   If a *.dom* file or .dos file has been loaded using `loadModule` during server initialization, using `use` to load a file with the same name after startup will not take effect.


Related statement: [module](module.md)

**Parent topic:**[Programming Statements](../../Programming/ProgrammingStatements/programming_statements.md)

