# transaction {#transaction}

**Parent topic:**[Programming Statements](../../Programming/ProgrammingStatements/programming_statements.md)

## Syntax {#syntax}

```
transaction{
     <statement block>;
}
```

## Details {#details}

The transaction statement encapsulates multiple SQL statements on an in-memory table or a shared table\(including shared table and MVCC table\) into one transaction to guarantee atomicity, consistency, and isolation of these SQL statements as a group. If an error occurs during the execution of any of these SQL statements, all statements will be rolled back together.

Note: Currently, transaction only supports SQL statements except for `create`, `alter`, `insert into`.

## Examples {#examples}

```
sym = `C`MS`MS`MS`IBM`IBM`C`C`C$SYMBOL
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800
timestamp = [09:34:07,09:36:42,09:36:51,09:36:59,09:32:47,09:35:26,09:34:16,09:34:26,09:38:12]
t = table(timestamp, sym, qty, price);

share t as pub

def update_date(){
  update pub set qty=qty-50 where sym=`C
  update pub set price=price-0.5 where sym=`MS
  select ts from pub // column `ts does not exist
}
transaction {
  update_date()
}

eqObj(pub[`qty], qty)
true

eqObj(pub[`price], price)
true
```

