# share {#share}

## Syntax {#syntax}

share &lt;table&gt; as &lt;shared name&gt;

or

share &lt;table&gt; as &lt;db&gt;.&lt;table name&gt; on &lt;column name&gt;

or

share &lt;engine&gt; as &lt;engine name&gt;

## Details {#details}

For the first usage: share the given table across all sessions with a shared name. Local objects including tables are invisible to other sessions. They need to be shared before they are visible to other sessions. The shared name must be different from any regular table name on all sessions. One server can support up to 65,535 shared tables.

For the second usage: populate a shard of a distributed table. The sharding is based on the given column. Multiple share statements are used together to save a distributed table on multiple nodes.

For the third usage: share an engine and apply a write lock for concurrent writes \(The shared engine must keep the same name as the original\). To obtain the engine handle from another session, use function `getStreamEngine`.

Note that it is not allowed to share a stream table multiple times by modifying the shared table name.

## Examples {#examples}

-   For the first usage:


```
t1= table(1 2 3 as id, 4 5 6 as value);
share t1 as table1;
```

-   For the second usage:


First, configure 2 nodes. Enter the following command in a command prompt \(node 8500\):

```
dolphindb -logFile dolphindb.log0 -maxMemSize 50 -localSite localhost:8500:local8500 -sites localhost:8500:local8500,localhost:8501:local8501
```

Enter the following command in another command prompt \(node 8501\):

```
dolphindb -logFile dolphindb.log1 -maxMemSize 50 -localSite localhost:8501:local8501 -sites localhost:8500:local8500,localhost:8501:local8501
```

Then run the following script on node 8500:

```
TickDB = database("C:/DolphinDB/Data/shareEx", RANGE, `A`M`ZZZZ, `local8500`local8501)
t=table(rand(`AAPL`IBM`C`F,100) as sym, rand(1..10, 100) as qty, rand(10.25 10.5 10.75, 100) as price)
share t as TickDB.Trades on sym;
```

Run the following script on node 8501:

```
TickDB = database("C:/DolphinDB/Data/shareEx", RANGE, `A`M`ZZZZ, `local8500`local8501)
t=table(rand(`WMI`PG`TSLA,100) as sym, rand(1..10, 100) as qty, rand(10.25 10.5 10.75, 100) as price)
share t as TickDB.Trades on sym;
```

Then we can use Trades or TickDB.Trades to refer to the table. On either node we can enter the following script:

```
select count(*) from Trades;
```

|count|
|-----|
|200|

-   For the third usage


```
trades = streamTable(1:0, `time`sym`price, [TIMESTAMP, SYMBOL, DOUBLE])
share table(100:0, `sym`time`factor1, [SYMBOL, TIMESTAMP, DOUBLE]) as outputTable
engine = createReactiveStateEngine(name="test", metrics=[<time>, <mavg(price, 3)>], dummyTable=trades, outputTable=outputTable, keyColumn=`sym)
// share engine
share engine as "test"
```

Excute the following script in any of the sessions to which the node is connected:

```
// define function write1 to write to the engine
def write1(mutable engine) {
  N = 10
  for (i in 1..500) {
      data = table(take(now(), N) as time, take(`A`B, N) as sym, rand(10.0, N) as price)
      getStreamEngine(engine).append!(data)
  }
}
// define function write2 to write to the engine
def write2(mutable engine) {
  N = 10
  for (i in 1..500) {
      data = table(take(now(), N) as time, take(`C`D, N) as sym, rand(10.0, N) as price)
      getStreamEngine(engine).append!(data)
  }
}
// submit jobs write to the engine at the same time
submitJob("j1", "j1", write1, "test")
submitJob("j2", "j2", write2, "test")
// The number of output records is 10000, which is exactly the sum of records written by write1 and write2.
select count(*) from outputTable
10000
```

Related functions: [Undefine Variables](../Objects/Variable/UndefineVariables.md), [undef](../../Functions/u/undef.md)

