# Assignment by Value {#assignment-by-value}

We use the "=" sign to imply the assignment by value. It makes a new copy of the object in memory and assigns it to the new variable.

**Parent topic:**[Assignment](../../../Programming/ProgrammingStatements/Assignment/Assignment.md)

## Syntax {#syntax}

For variables:

&lt;variable&gt;=&lt;object&gt;

or

&lt;variable&gt;\[index\]=&lt;object&gt;

For constant variables:

const &lt;variable&gt;=&lt;object&gt;

## Examples {#examples}

```
y=6 4 7
// output: [6,4,7]

x=y;
x;
// output: [6,4,7]
y[1]=0;
// output: [6,0,7]
x;
// output: [6,4,7]
// modifying y does does not affect x

const a=10;
```

Release an object: &lt;variable&gt;=NULL or use the undef command. Sometimes, to reduce the footprint of an application, we would like to release some variables from the system memory.

```
x=6 4 7;
x;
// output: [6,4,7]
x=NULL;
x;
// output: NULL


x=6 4 7;
undef(`x, VAR);
x;
// output: Syntax Error: [line #1] Cannot recognize the token x
```

DolphinDB also supports the following assignment operators: +=, -=, \*=, /= and =.

```
x=0;
x+=5;
x;
// output: 5
// equivalent to x=x+5

x=5;
x-=2;
x;
// output: 3
// equivalent to x = x - 2

x=5
x*=5;
x;
// output: 25
// equivalent to  x = x * 5

x=5;
x/=2;
x;
// output: 2
// equivalent to  x = x / 5.

x=5;
x\=2;
x;
// output: 2.5

x=1 2 3 4 5;
x[1 3]+=10;

x;
// output: [1,12,3,14,5]
```

