# sub\(-\) {#sub-}

**Parent topic:**[Operators](../../../Programming/Operators/Operators.md)

## Syntax {#syntax}

X - Y

## Arguments {#arguments}

**X** and **Y** is a scalar/pair/vector/matrix/set. If one of *X* and *Y* is a pair/vector/matrix, the other is a scalar or a pair/vector/matrix of the same size.

## Details {#details}

Return the result of element-by-element subtracting *Y* from *X*. If both *X* and *Y* are sets, sub returns a set by eliminating the common elements of *X* and *Y* from *X*.

## Examples {#examples}

```
4:5-2;
// output: 2 : 3

4:5-1:2;
// output: 3 : 3

x=1 2 3;
x-1;
// output: [0,1,2]

1 sub x;
// output: [0,-1,-2]

y=4 5 6;
sub(x,y);
// output: [-3,-3,-3]

m1=1..6$2:3;
m1;
```

|\#0|\#1|\#2|
|---|---|---|
|1|3|5|
|2|4|6|

```
m-2;
```

|\#0|\#1|\#2|
|---|---|---|
|-1|1|3|
|0|2|4|

```
m2=6..1$2:3;
m2;
```

|\#0|\#1|\#2|
|---|---|---|
|6|4|2|
|5|3|1|

```
m1-m2;
```

|\#0|\#1|\#2|
|---|---|---|
|-5|-1|3|
|-3|1|5|

```
x=set([5,3,4]);
y=set(8 9 4 6);
x-y;
// output: set(3,5)
y-x;
// output: set(6,9,8)
```

