# seq\(..\) {#seq}

**Parent topic:**[Operators](../../../Programming/Operators/Operators.md)

## Syntax {#syntax}

a..b

## Arguments {#arguments}

**a** and **b** must be integral or temporal types.

## Details {#details}

Returns a vector starting from *a* and ending at *b*. The step between two adjacent elements is 1.

Note: If both *a* and *b* are integral or temporal NULLs, an empty vector is returned.

## Examples {#examples}

```
x=0..3;
x;
// output: [0,1,2,3]

// add a scalar to a sequence
1..3+1;
// output: [2,3,4]

11..1;
// output: [11,10,9,8,7,6,5,4,3,2,1]

seq(3,1);
// output: [3,2,1]

2015.01M..2015.12M;
// output: [2015.01M,2015.02M,2015.03M,2015.04M,2015.05M,2015.06M,2015.07M,2015.08M,2015.09M,2015.10M,2015.11M,2015.12M]

2016.01.01..2016.01.07;
// output: [2016.01.01,2016.01.02,2016.01.03,2016.01.04,2016.01.05,2016.01.06,2016.01.07]
```

