# or\(\|\|\) {#or}

## Syntax {#syntax}

`(X,Y)` or `X||Y`

## Arguments {#arguments}

**X** and **Y** is a scalar/pair/vector/matrix. If *X* or *Y* is a pair/vector/matrix, the other is a scalar or a pair/vector/matrix of the same size.

## Details {#details}

Return the element-by-element logical *X* OR *Y*. If the operands contain null values, the operator \|\| returns NULL.

**Note:**

If the operands of `or` or `||` contain null values, the operator `||` returns NULL, while the function or returns different results for different server versions:

-   For versions earlier than 1.30.21.4/2.00.9.4, `or` returns NULL.

-   For version 1.30.21.4/2.00.9.4 or higher, the result may differ based on the configuration parameter *logicOrIgnoreNull*.


|Operand A|Operand B|result \(when logicOrIgnoreNull= true\)|result \(when logicOrIgnoreNull= false\)|
|---------|---------|---------------------------------------|----------------------------------------|
|non-zero|NULL|true|NULL|
|zero|NULL|false|NULL|
|NULL|NULL|NULL|NULL|

## Examples {#examples}

```
1 || 0;
// output: 1

x=1 0 1;
x || 0;
// output: [1,0,1]

y=0 1 0;
x or y;
// output: [1,1,1]

m1=1 1 1 0 0 0$2:3;
m1;
```

|\#0|\#1|\#2|
|---|---|---|
|1|1|0|
|1|0|0|

```
m1 || 0;
```

|\#0|\#1|\#2|
|---|---|---|
|1|1|0|
|1|0|0|

```
m2=1 0 1 0 1 0$2:3;
m2;
```

|\#0|\#1|\#2|
|---|---|---|
|1|1|1|
|0|0|0|

```
or(m1, m2);
```

|\#0|\#1|\#2|
|---|---|---|
|1|1|1|
|1|0|0|

```
t=table(1..3 as id, 4..6 as value);
t;
```

|id|value|
|---|-----|
|1|4|
|2|5|
|3|6|

```

select id, value from t where id=2 or id=3;
```

|id|value|
|---|-----|
|2|5|
|3|6|

Related topics: [and](../../../Functions/a/and.md), [not](../../../Functions/n/not.md)

