# at\(\[\]\) {#at}

**Parent topic:**[Operators](../../../Programming/Operators/Operators.md)

## Syntax {#syntax}

X\[index\]

## Arguments {#arguments}

**X** can be a scalar/vector\(including tupleand array vector\)/matrix/table/dictionary/pair/function.

**index** can be a Boolean expression/scalar/vector/tuple/array vector/pair.

## Details {#details}

If *index* is a Boolean expression, returns the elements in *X* that satisfy the condition specified by *index* \(i.e., *index* = true\). If not, returns the elements in *X* with the corresponding *index*. If *X* is a function, *index* is used as an argument of *X*. It is equivalent to function [at](../../../Functions/a/at.md).

**Note**: When *index* is a tuple \(e.g., *index* = \(0, 1\) \), and *X* is a tuple of vectors, X\[\(0, 1\)\] returns the value at position 1 of the first element in *X*.

The following table shows the data forms supported by *X* and *index*.

|X/index|Boolean expression|scalar|vector|tuple|pair|
|-------|------------------|------|------|-----|----|
|scalar|√|√|√|×|√|
|vector|√|√|√|√|√|
|tuple|√|√|√|√|√|
|matrix|√|√|√|√|√|
|table|√|√|√|×|√|
|dictionary|×|√|√|×|×|
|pair|√|√|√|√|√|
|function|√|√|√|√|√|

|X/index|Boolean expression|scalar|vector|array vector|tuple|pair|
|-------|------------------|------|------|------------|-----|----|
|scalar|√|√|√|×|×|√|
|vector|√|√|√|√|√|√|
|tuple|√|√|√|×|√|√|
|array vector|√|√|√|×|×|√|
|matrix|√|√|√|×|√|√|
|table|√|√|√|×|×|√|
|dictionary|×|√|√|×|×|×|
|pair|√|√|√|×|√|√|
|function|√|√|√|√|√|√|

## Examples {#examples}

```
x=5 7 0 4 2 3;
x[x>3];
[5,7,4]
x at x>3;
[5,7,4]

shares=500 1000 1000 600 2000;
prices=25.5 97.5  19.2 38.4 101.5;
prices[shares>800];
[97.5,19.2,101.5]

// returns business days between 2017.01.01 and 2017.01.07.
dates=2017.01.01..2017.01.07;
dates[x->x.weekday() between 1:5];
[2017.01.02,2017.01.03,2017.01.04,2017.01.05,2017.01.06]

// when index is specified as a tuple 
tp = [2.3 2.1 2.2, 3.1 2.9 2.8, 5.7 6.9]
tp at [1 2 3, 0 1 2]
([3.1,2.9,2.8],[5.7,6.9,],)

(sum)[1..10]
 55

(corr)[1 3 -1, 2 3 4]
 -0.5000
```

Related functions: [eachAt](eachAt.md)

