# and\(&amp;&amp;\) {#and}

**Parent topic:**[Operators](../../../Programming/Operators/Operators.md)

## Syntax {#syntax}

X &amp;&amp; Y

## Arguments {#arguments}

**X** and **Y** is a scalar/pair/vector/matrix. If *X* or *Y* is a pair/vector/matrix, the other is a scalar or a pair/vector/matrix of the same size.

## Details {#details}

Return the element-by-element logical *X* AND *Y*.

## Examples {#examples}

```
1 && 3;
// output: 1

x=1 2 3;
x && 0;
// output: [0,0,0]

x=1 2 3;
y=0 1 0;
x && y;
// output: [0,1,0]

m1=1 1 1 0 0 0$2:3;
m1;
```

|\#0|\#1|\#2|
|---|---|---|
|1|1|0|
|1|0|0|

```
m1 && 0;
```

|\#0|\#1|\#2|
|---|---|---|
|0|0|0|
|0|0|0|

```
m2=1 0 1 0 1 0$2:3;
m2;
```

|\#0|\#1|\#2|
|---|---|---|
|1|1|1|
|0|0|0|

```
and(m1, m2);
```

|\#0|\#1|\#2|
|---|---|---|
|1|1|0|
|0|0|0|

```
t=table(1 2 2 3 as id, 4 5 6 5 as value);
t;
```

|id|value|
|---|-----|
|1|4|
|2|5|
|2|6|
|3|5|

```
// output: select id, value from t where id=2 and value=5;   // SQL query
```

|id|value|
|---|-----|
|2|5|

