# Variable {#variable}

A variable can store data of any types.

-   **[Undefine Variables](../../../Programming/Objects/Variable/UndefineVariables.md)**  


**Parent topic:**[Objects](../../../Programming/Objects/Objects.md)

## Naming Rules {#naming-rules}

\(1\) A valid variable name consists of letters, digits, or \_.

\(2\) A valid variable name must begin with a letter.

Examples of valid variable names:

```
x1 = 5;

varName = `TEST;

file_name = "text.txt";
```

Examples of invalid variable names:

```
x.1 = 5;

var~2 = 7;

file-name = 6;

1x = 5;
```

## Variable Examples {#variable-examples}

```
m=matrix(INT,3,3);

z = dict(INT,DOUBLE);

x = 1..10;

x = true;
```

In contrast to a constant, a variable's value can be modified. In the following example, x is defined as an integer vector variable, but becomes a double vector.

```
x=1 2 3;
x;
// output: [1,2,3]

x=3.5 4.5;
x;
// output: [3.5,4.5]
```

## Variable and Variable Names {#variable-and-variable-names}

Variable and variable name are different concepts. Variable is a place holder for an object. Variable names are strings. To refer a variable, we don't need to quote the variable name. DolphinDB provides a couple of built-in functions to manipulate variables. For example, [undef](../../../Functions/u/undef.md) to undefine one or multiple variables, and [defined](../../../Functions/d/defined.md) to check if one or multiple variables exist. These functions look for variable names as input arguments rather than the objects the variables refer to.

Some of the built-in functions accept data type as an argument. For example, array, matrix, dictionary, set, function definition, etc. DolphinDB has 3 ways to represent a data type. The first is type enumerations such as INT, DOUBLE, BOOL. They are in upper cases and are reserved \(i.e. these phrases can't be used as column names, variable names, or function names\). We recommend this approach. The second is type function names such as int, long, string, double, bool etc. As these vocabulary could be used as a variable name, we should avoid this approach if the data type name has been used as a local variable. The third approach is quoted type names \(i.e. strings\).

Reserved Words and Keywords

The reserved words cannot be used as variable names. Reserved words include the following categories:

1.  Data types: VOID, BOOL, CHAR, SHORT, INT, LONG, DATE, MONTH, TIME, MINUTE, SECOND, DATETIME, TIMESTAMP, NANOTIME, NANOTIMESTAMP, FLOAT, DOUBLE, SYMBOL, STRING, UUID, FUNCTIONDEF, HANDLE, CODE, DATASOURCE, RESOURCE, ANY, IPADDR, INT128, BLOB, COMPLEX, POINT, DURATION.

2.  Data forms: SCALAR, PAIR, VECTOR, MATRIX, SET, DICT, TABLE.

3.  Graph types: LINE, PIE, COLUMN, BAR, AREA, HISTOGRAM, SCATTER.

4.  Partition schemes: VALUE, RANGE, HASH, LIST, COMPO.

5.  For function [undef](../../../Functions/u/undef.md): VAR, SHARED, DEF.

6.  For function [seek](../../../Functions/s/seek.md): HEAD, CURRENT, TAIL.

7.  Special values: NULL, pi, e.


Keywords have special meaning in DolphinDB scripting language. They cannot be used as variable names either. Keywords include the following categories:

1.  Loops: for, do, if, continue, break

2.  SQL: select, exec, delete, update

3.  Boolean: true, false

4.  Function: def, return

5.  Modules: module, use

6.  Exception messages: try, throw

7.  Others: assert, const, share, timer


