# SQL Query {#sql-query}

All types of objects mentioned in this chapter can be part of a SQL query.

```
// create a table with column x that contains 20 million random floating numbers from 0 to 10000.0
t1 = table(rand(10000.0, 20000000) as x);

// calculate the average for column x
select avg(x) as avgx from t1;
```

|avgx|
|----|
|4999.549816|

```
t = table(1..6 as x, 11..16 as y, 101..106 as z);
t;
```

|x|y|z|
|---|---|---|
|1|11|101|
|2|12|102|
|3|13|103|
|4|14|104|
|5|15|105|
|6|16|106|

```
shape(select x, y from t where x>2);
// output: 4 : 2
```

For details about SQL query, please refer to [SQL Statements](../SQLStatements/SQLStatement.md).

**Parent topic:**[Objects](../../Programming/Objects/Objects.md)

