# Named Object {#named-object}

**Parent topic:**[Objects](../../Programming/Objects/Objects.md)

## Syntax {#syntax}

```

<Object Definition> as <ObjectName>
```

Named object is an object with an explicit name. Currently, the named object is limited to vectors. When a vector is bound to a variable, the vector will implicitly use the variable name as the vector object name.

## Example {#example}

\(1\) create a table

```
t = table(1..5 as id, rand(100, 5) as price);
t;
// t.id and t.price are named objects.
```

|id|price|
|---|-----|
|1|34|
|2|33|
|3|28|
|4|84|
|5|6|

\(2\) SQL query

```

select price as x from t;
```

|x|
|---|
|34|
|33|
|28|
|84|
|6|

\(3\) plot

```
plot([1..10 as x, 21..30 as y], 2016.10.01..2016.10.10 as date)
```

