# Constant {#constant}

There are only 2 data forms that can be represented by constants directly: scalar and vector. Other data forms including pair, matrix, set, dictionary, and table must be returned from a function call. Functiondef and handle are also constants.

```
3;
// an integer constant

3.9;
// a double constant

1 2 3;
// an integer vector constant

(1, 2, 3)
// a constant tuple

`IBM`YAHOO`MS`GOOG
// a string vector constant

true;
// a boolean constant

NULL;
// special constant NULL
```

There are 2 built-in constants: pi and e. Built-in constants cannot be redefined.

```
pi*2;
// output: 6.283185

log e;
// output: 1

e=1;
// output: Syntax Error: [line #1] Please use '==' rather than '=' as equal operator in non-sql expression.
```

**Parent topic:**[Objects](../../Programming/Objects/Objects.md)

## Integer constants {#integer-constants}

Integer constants are constant data elements that have no fractional parts or exponents.

\(1\) data forms: SCALAR, PAIR, VECTOR, MATRIX, SET, DICT, TABLE.

```
x=set(1 2 3)
if(form(x) == SET){y=10};

y;
// output: 10

form x;
// output: 4
```

\(2\) data types: VOID, BOOL, CHAR, SHORT, INT, LONG, DATE, MONTH, TIME, MINUTE, SECOND, DATETIME, TIMESTAMP, NANOTIME, NANOTIMESTAMP, FLOAT, DOUBLE, SYMBOL, STRING, UUID, FUNCTIONDEF, HANDLE, CODE, DATASOURCE, RESOURCE, ANY, ANY DICTIONARY, DATEHOUR, IPADDR, INT128, BLOB, COMPLEX, POINT, DURATION.

```
x=(`ABC, 123);
type x;
// output: 24

(type x) == ANY;
// output: 1
```

\(3\) graph types: LINE, PIE, COLUMN, BAR, AREA, HISTOGRAM, SCATTER.

```
plot(1..5 as value, `IBM`MSFT`GOOG`XOM`C, `rank, BAR)
```

\(4\) location of the internal cursor in the [seek](../../Functions/s/seek.md) function: HEAD, CURRENT, TAIL. The following example returns the length of a file.

```
def fileLength(f): file(f).seek(0, TAIL)
fileLength("test.txt");
// output: 14
```

\(5\) types of objects to be undefined in the [undef](../../Functions/u/undef.md) command: VAR \(variable\), SHARED \(shared variable\) or DEF \(function definition\).

```
x=1 2 3;
undef(`x, VAR);
```

We can declare constant variables with: const variableName = value.

Constant variables are not mutable. After we declare a constant variable, we can't bind another object to the constant variable, nor can we modify the value of the bound object.

```
const a = 1 2 3;
a=4 5 6;
// output: Syntax Error: [line #1] Constant variable [a] can't be modified.

const a = 10;
a+=1;
// output: Syntax Error: [line #1] Constant variable [a] can't be modified.

const x = 1..10;
x[5]=0;
// output: Syntax Error: [line #1] Constant variable [x] can't be modified.
```

