# Member Variables {#Variable}

A member variable is a variable that is associated with a specific object, and accessible for all its member methods.

## Declaring Member Variables {#Declaring-Member-Variables .section}

When declaring a member variable, its data type must be specified. The declaration methods vary based on the data type of the variables:

**Scalars**

Scalars include basic data types such as INT, CHAR, FLOAT, DOUBLE, STRING, etc. The declaration method is: `variableName :: dataType`. For example: `age :: INT`, `name :: STRING`.

**Regular Vectors**

When declaring member variables as regular vectors, the method is similar to declaring scalars, but you need to add `VECTOR` after the data type to indicate that the member variable is a regular vector. The declaration method is: `variableName :: dataType VECTOR`. For example: `age :: INT VECTOR`, `name :: STRING VECTOR`.

**Array Vectors**

When declaring member variables as array vectors, the method is similar to declaring regular vectors, but you need to add `[]` after the data type to indicate that the member variable is an array vector. The declaration method is: `variableName :: dataType[] VECTOR`. For example: `age :: INT[] VECTOR`.

**Parent topic:**[Object-Oriented Programming](../../Programming/OOP/ObjectOrientedProgramming.md)

