# Classes and Objects {#Class}

A class defines the attributes \(member variables\), constructors, and behaviors \(methods\) of objects.

## Defining a Class {#Defining-a-Class .section}

**Syntax**

``` {#codeblock_ndf_pwt_4bc}
class ClassName{
    attribute1 :: dataType
    attribute2 :: dataType
    
    // Define class
    def ClassName(parameter1, parameter2){
        attribute1 = parameter1
        attribute2 = parameter2
    }
    
    // Define method
    def method1(parameter){        
    }
}
```

**Note:**

-   Class names cannot start with a number, contain spaces or any special characters except underscores \(\_\).

-   Parameters cannot have the same name as attributes, otherwise attributes will be overwritten.

-   JIT and destructors are not supported currently.


For example, define a class `Person`:

``` {#codeblock_fvq_rwt_4bc}
class Person {
  name :: STRING
  age :: INT
  def Person(name_, age_) { 
    name = name_
    age = age_
  }
  def setName(newName) {
    name = newName
  }
  def getName(year, gender) {
          if(year<2020)
                  return year
    else
            return name
  }
}
```

## Instantiating an Object {#Instantiating-an-Object .section}

A class is a template for objects, and an object is an instance of class.

The following example instantiates an object of class `Student`:

``` {#codeblock_hrg_swt_4bc}
a = Person("Harrison",20)
```

**Parent topic:**[Object-Oriented Programming](../../Programming/OOP/ObjectOrientedProgramming.md)

