# Composite Function {#composite_function}

A composite function is created by combining two functions, equivalent to `f(g(x))`. Here, *x* is the input argument\(s\), which can be one or more. The core idea of a composite function is to use the output of one function as the input to the other, creating a new, combined function. This can enhance code readability, make it easier to maintain, and simplify complex logic.

In DolphinDB, composite functions can be created using the [compose](../../Functions/c/compose.md) function. The `compose(first, second)` function takes two functions as arguments. It first calls the *first*function with the given parameters, then passes the result as the input to the *second* function, and returns the final result of `second(first(...))`. The new function returned by `compose` has the same parameters as the *first*function.

Let’s say we have two simple functions: `doubleValue` and `increment`. We can combine these two functions into a new composite function that first applies `doubleValue`, then uses the result as input for `increment`, and finally returns the outcome.

``` {#codeblock_ans_k3q_dfc}
// Define two simple functions
doubleValue = x -> x * 2
increment = x -> x + 1

// Create a composite function
composedFunc = compose(doubleValue, increment)

composedFunc([3, 4, 5])  // Output: [7, 9, 11]
```

**Parent topic:**[Functional Programming](../../Programming/FunctionalProgramming/FunctionalProgramming.md)

