# Remote Function Call {#remote-function-call}

There are two ways to make remote function calls:

-   call a built-in function remotely

-   run a local function \(user-defined\) remotely


**Parent topic:**[Functional Programming](../../Programming/FunctionalProgramming/FunctionalProgramming.md)

## Syntax {#syntax}

Build a remote connection:

```
host = xdb(URL, Port)
```

Remote function call:

```
host("functionName", functionParameters)
```

or

```
remoteRun(host, "functionName", functionParameters)
```

or

```
remoteRunWithCompression(host, "functionName", functionParameters)
```

## Remote system function call {#remote-system-function-call}

```
h=xdb("localhost",80);
h("sum",rand(100, 1000));
// output: 50971

remoteRun(h, "sum", rand(100, 1000));
// output: 48704
```

## Remote user defined function call {#remote-user-defined-function-call}

```
def f1(a): sin(rand(100.0,a))
def f2(a,b):return b+f1(a)
pools=each(xdb, "localhost",82)
result = peach(remoteRun{, f2, 100, 0.5}, pools)
result;
```

