# File Operations {#file-operations}

General file operations including listing files, opening or closing a file, and moving cursor within a file.

-   **[Binary File Processing](../../Programming/FileOperations/BinaryFileProcessing.md)**  

-   **[Table Import and Export](../../Programming/FileOperations/TableImportandExport.md)**  

-   **[Text File Processing](../../Programming/FileOperations/TextFileProcessing.md)**  


**Parent topic:**[Programming Guide](../../Programming/programming_basics.md)

## List Files {#list-files}

To list files and sub-directories within a directory, use the [files](../../Functions/f/files.md) function. It returns next information of files.

-   File names.

-   A directory or not. \(0:file , 1:directory\)

-   Size of files.

-   Last accessed time.

-   Last modified time.


```
files("C:/DolphinDB");
```

|filename|isDir|fileSize|lastAccessed|lastModified|
|--------|-----|--------|------------|------------|
|LICENSE\_AND\_AGREEMENT.txt|0|22558|1495508675000|1483773234998|
|README\_WIN.txt|0|5104|1495508675000|1483866232680|
|server|1|0|1496624932437|1496624932437|
|THIRD\_PARTY\_SOFTWARE\_LICENS...|0|8435|1495508675000|1483628426506|

```
files("C:/DolphinDB", "readme%");
```

|filename|isDir|fileSize|lastAccessed|lastModified|
|--------|-----|--------|------------|------------|
|README\_WIN.txt|0|5104|1495508675000|1483866232680|

Alternatively, we can use SQL expressions to manipulate the returned table.

```
select * from files("C:/DolphinDB") where filename like "DolphinDB%";
```

|filename|isDir|fileSize|lastAccessed|lastModified|
|--------|-----|--------|------------|------------|
|DolphinDB 1.lnk|0|824|1499933602000|1500344826000|
|DolphinDB 2.lnk|0|790|1499933685000|1501832205000|
|DolphinDB 3.lnk|0|1006|1501829666000|1501832213000|
|DolphinDB 4\(acl\).lnk|0|872|1501829402000|1502626190412|

## Open and Close Files {#open-and-close-files}

The file function can open a file with a given mode. The opening mode could be one of the 6 modes: "r", "r+", "w", "w+", "a", and "a+". \(For details please see [file](../../Functions/f/file.md) \)The [close](../../Functions/c/close.md) function closes an opened file handle.

```
fout=file("C:/DolphinDB/test.txt","w");
fout.writeLine("hello world!");
// output: 1

fout.close();
fin = file("C:/DolphinDB/test.txt");
print fin.readLine();
// output: hello world!

fin.close();
```

In the example below, a file is opened within a function and it will be automatically closed when the function call completes. We don't have to explicitly close the file in many cases unless it is necessary to close the file immediately. When the system shuts down, all open files will be closed.

```
def myread(f): file(f).readLine()
myread("C:/DolphinDB/test.txt");
// output: Hello World!
```

## Move Cursor within a File {#move-cursor-within-a-file}

When the system reads data from a file or writes data to a file, the internal cursor moves forward. Users can manipulate the cursor manually via the [seek](../../Functions/s/seek.md) function. In addition to the file handle, the seek function accepts another 2 arguments: offset and the starting position. The offset could be positive or negative and the starting position must be of one the 3 positions: HEAD, CURRENT, and TAIL. The seek function returns the final position of the internal cursor if no exception is raised.

```
// write a function to show the length of a file
def fileLength(f): file(f).seek(0, TAIL)
fileLength("C:/DolphinDB/test.txt");
// output: 14

// move the internal cursor to the beginning of the file
fin=file("C:/DolphinDB/test.txt")
fin.readLine();
// output: Hello World!
fin.seek(0, HEAD);
// output: 0
fin.readLine();
// output: Hello World!
```

