# Data Types {#chap4_sect_data_type_description}

<table id="table_wm3_glr_c1c"><thead><tr><th align="left">

Category

</th><th align="left">

Data Type Name

</th><th align="left">

ID

</th><th align="left">

Examples

</th><th align="left">

Symbol

</th><th align="left">

Size

</th><th align="left">

Range

</th></tr></thead><tbody><tr><td align="left">

VOID

</td><td align="left">

VOID

</td><td align="left">

0

</td><td align="left">

NULL

</td><td align="left">



</td><td align="left">

1

</td><td align="left">



</td></tr><tr><td align="left">

LOGICAL

</td><td align="left">

BOOL

</td><td align="left">

1

</td><td align="left">

1b, 0b, true, false

</td><td align="left">

b

</td><td align="left">

1

</td><td align="left">

0~1

</td></tr><tr><td rowspan="5" align="left">

INTEGRAL

</td><td align="left">

CHAR

</td><td align="left">

2

</td><td align="left">

'a', 97c

</td><td align="left">

c

</td><td align="left">

1

</td><td align="left">

-2 7 +1~2 7 -1

</td></tr><tr><td align="left">

SHORT

</td><td align="left">

3

</td><td align="left">

122h

</td><td align="left">

h

</td><td align="left">

2

</td><td align="left">

-2 15 +1~2 15 -1

</td></tr><tr><td align="left">

INT

</td><td align="left">

4

</td><td align="left">

21

</td><td align="left">

i

</td><td align="left">

4

</td><td align="left">

-2 31 +1~2 31 -1

</td></tr><tr><td align="left">

LONG

</td><td align="left">

5

</td><td align="left">

22l

</td><td align="left">

l

</td><td align="left">

8

</td><td align="left">

-2 63 +1~2 63 -1

</td></tr><tr><td align="left">

COMPRESSED

</td><td align="left">

26

</td><td align="left">



</td><td align="left">



</td><td align="left">

1

</td><td align="left">

-2 7 +1~2 7 -1

</td></tr><tr><td rowspan="10" align="left">

TEMPORAL

</td><td align="left">

DATE

</td><td align="left">

6

</td><td align="left">

2013.06.13

</td><td align="left">

d

</td><td align="left">

4

</td><td align="left">



</td></tr><tr><td align="left">

MONTH

</td><td align="left">

7

</td><td align="left">

2012.06M

</td><td align="left">

M

</td><td align="left">

4

</td><td align="left">



</td></tr><tr><td align="left">

TIME

</td><td align="left">

8

</td><td align="left">

13:30:10.008

</td><td align="left">

t

</td><td align="left">

4

</td><td align="left">



</td></tr><tr><td align="left">

MINUTE

</td><td align="left">

9

</td><td align="left">

13:30m

</td><td align="left">

m

</td><td align="left">

4

</td><td align="left">



</td></tr><tr><td align="left">

SECOND

</td><td align="left">

10

</td><td align="left">

13:30:10

</td><td align="left">

s

</td><td align="left">

4

</td><td align="left">



</td></tr><tr><td align="left">

DATETIME

</td><td align="left">

11

</td><td align="left">

2012.06.13 13:30:10 or 2012.06.13T13:30:10

</td><td align="left">

D

</td><td align="left">

4

</td><td align="left">

\[1901.12.13T20:45:53, 2038.01.19T03:14:07\]

</td></tr><tr><td align="left">

TIMESTAMP

</td><td align="left">

12

</td><td align="left">

2012.06.13 13:30:10.008 or 2012.06.13T13:30:10.008

</td><td align="left">

T

</td><td align="left">

8

</td><td align="left">



</td></tr><tr><td align="left">

NANOTIME

</td><td align="left">

13

</td><td align="left">

13:30:10.008007006

</td><td align="left">

n

</td><td align="left">

8

</td><td align="left">



</td></tr><tr><td align="left">

NANOTIMESTAMP

</td><td align="left">

14

</td><td align="left">

2012.06.13 13:30:10.008007006 or 2012.06.13T13:30:10.008007006

</td><td align="left">

N

</td><td align="left">

8

</td><td align="left">

\[1677.09.21T00:12:43.145224193, 2262.04.11T23:47:16.854775807\]

</td></tr><tr><td align="left">

DATEHOUR

</td><td align="left">

28

</td><td align="left">

2012.06.13T13

</td><td align="left">



</td><td align="left">

4

</td><td align="left">



</td></tr><tr><td rowspan="2" align="left">

FLOATING

</td><td align="left">

FLOAT

</td><td align="left">

15

</td><td align="left">

2.1f

</td><td align="left">

f

</td><td align="left">

4

</td><td align="left">

Sig. Fig. 06-09

</td></tr><tr><td align="left">

DOUBLE

</td><td align="left">

16

</td><td align="left">

2.1

</td><td align="left">

F

</td><td align="left">

8

</td><td align="left">

Sig. Fig. 15-17

</td></tr><tr><td rowspan="3" align="left">

LITERAL

</td><td align="left">

SYMBOL

</td><td align="left">

17

</td><td align="left">



</td><td align="left">

S

</td><td align="left">

4

</td><td align="left">



</td></tr><tr><td align="left">

STRING

</td><td align="left">

18

</td><td align="left">

"Hello" or 'Hello' or \`Hello

</td><td align="left">

W

</td><td align="left">

≤ 65,535

</td><td align="left">



</td></tr><tr><td align="left">

BLOB

</td><td align="left">

32

</td><td align="left">



</td><td align="left">



</td><td align="left">

 

</td><td align="left">



</td></tr><tr><td rowspan="4" align="left">

BINARY

</td><td align="left">

INT128

</td><td align="left">

31

</td><td align="left">

e1671797c52e15f763380b45e841ec32

</td><td align="left">



</td><td align="left">

16

</td><td align="left">

-2 127 +1~2 127 -1

</td></tr><tr><td align="left">

UUID

</td><td align="left">

19

</td><td align="left">

5d212a78-cc48-e3b1-4235-b4d91473ee87

</td><td align="left">



</td><td align="left">

16

</td><td align="left">



</td></tr><tr><td align="left">

IPADDR

</td><td align="left">

30

</td><td align="left">

192.168.1.13

</td><td align="left">



</td><td align="left">

16

</td><td align="left">



</td></tr><tr><td align="left">

POINT

</td><td align="left">

35

</td><td align="left">

\(117.60972, 24.118418\)

</td><td align="left">



</td><td align="left">

16

</td><td align="left">



</td></tr><tr><td rowspan="8" align="left">

SYSTEM

</td><td align="left">

FUNCTIONDEF

</td><td align="left">

20

</td><td align="left">

def f1\(a,b\) \{return a+b;\}

</td><td align="left">



</td><td align="left">



</td><td align="left">



</td></tr><tr><td align="left">

HANDLE

</td><td align="left">

21

</td><td align="left">

file handle, socket handle, and db handle

</td><td align="left">



</td><td align="left">



</td><td align="left">



</td></tr><tr><td align="left">

CODE

</td><td align="left">

22

</td><td align="left">

&lt;1+2&gt;

</td><td align="left">



</td><td align="left">



</td><td align="left">



</td></tr><tr><td align="left">

DATASOURCE

</td><td align="left">

23

</td><td align="left">



</td><td align="left">



</td><td align="left">



</td><td align="left">



</td></tr><tr><td align="left">

RESOURCE

</td><td align="left">

24

</td><td align="left">



</td><td align="left">



</td><td align="left">



</td><td align="left">



</td></tr><tr><td align="left">

DURATION

</td><td align="left">

36

</td><td align="left">

1s, 3M, 5y, 200ms

</td><td align="left">



</td><td align="left">

4

</td><td align="left">



</td></tr><tr><td align="left">

INSTRUMENT

</td><td align="left">

42

</td><td align="left">

``` {#codeblock_t1k_jcq_mgc}
bond = {
    "productType": "Cash",
    "assetType": "Bond",
    "bondType": "DiscountBond",
    "version": 0, 
    "instrumentId": "259924.IB",
    "start": 2025.04.17,
    "maturity": 2025.07.17,
    "issuePrice": 99.664,
    "dayCountConvention": "ActualActual"
}
instrument = parseInstrument(bond)
```

</td><td align="left">

 

</td><td align="left">

 

</td><td align="left">

 

</td></tr><tr><td align="left">

MKTDATA

</td><td align="left">

43

</td><td align="left">

``` {#codeblock_s4y_jcq_mgc}
eqSpot = {
    "mktDataType": "Spot",
    "referenceDate": 2025.06.07,
    "version": 0, 
    "spotType": "EqSpot",
    "value": 3461.66,
    "unit": "CNY"
}
mktData=parseMktData(eqSpot)
```

</td><td align="left">

 

</td><td align="left">

 

</td><td align="left">

 

</td></tr><tr><td rowspan="2" align="left">

MIXED

</td><td align="left">

ANY

</td><td align="left">

25

</td><td align="left">

\(1,2,3\)

</td><td align="left">



</td><td align="left">



</td><td align="left">



</td></tr><tr><td align="left">

ANY DICTIONARY

</td><td align="left">

25

</td><td align="left">

\{a:1,b:2\}

</td><td align="left">



</td><td align="left">



</td><td align="left">



</td></tr><tr><td align="left">

OTHER

</td><td align="left">

COMPLEX

</td><td align="left">

34

</td><td align="left">

2.3+4.0i

</td><td align="left">



</td><td align="left">

16

</td><td align="left">



</td></tr><tr><td rowspan="3" align="left">

DECIMAL

</td><td align="left">

DECIMAL32\(S\)

</td><td align="left">

37

</td><td align="left">

3.1415926$DECIMAL32\(3\)

</td><td align="left">



</td><td align="left">

4

</td><td align="left">

\(-1\*10^\(9-S\), 1\*10^\(9-S\)\)

</td></tr><tr><td align="left">

DECIMAL64\(S\)

</td><td align="left">

38

</td><td align="left">

3.1415926$DECIMAL64\(3\), 3.141P

</td><td align="left">

P

</td><td align="left">

8

</td><td align="left">

\(-1\*10^\(18-S\), 1\*10^\(18-S\)\)

</td></tr><tr><td align="left">

DECIMAL128\(S\)

</td><td align="left">

39

</td><td align="left">

3.1415926$DECIMAL128\(3\)

</td><td align="left">



</td><td align="left">

16

</td><td align="left">

\(-1\*10^\(38-S\), 1\*10^\(38-S\)\)

</td></tr><tr><td align="left">

ARRAY

</td><td align="left">

Data types + the square bracket "\[\]", i.e., INT\[\], DOUBLE\[\], DECIMAL32\(3\)\[\], etc.

</td><td align="left">

IDs of data types + 64

</td><td align="left">

array\(INT\[\], 0, 10\).append!\(\[1 2 3, 4 5, 6 7 8, 9 10\]\)

</td><td align="left">



</td><td align="left">



</td><td align="left">



</td></tr></tbody>
</table>Note:

-   The following data types are not supported in table columns: VOID, FUNCTIONDEF, HANDLE, CODE, DATASOURCE, RESOURCE, COMPRESSED, DURATION.

-   DolphinDB uses STRING, BLOB and SYMBOL data types to represent strings.

    -   Values of BLOB type do not participate in calculations. Its size is not limited in memory, but there is an upper limit when writing to a distributed database.

    -   SYMBOL is a special STRING type. When a column is of SYMBOL type, the number of unique values must be less than 2,097,152 \(2^21\), otherwise the error "One symbase's size can't exceed 2097152" will be reported.

    -   Version 1.30.23/2.00.11 added size constraints for STRING, BLOB, and SYMBOL data written to distributed databases:

        -   Data of STRING type must be smaller than 64 KB, otherwise it will be truncated to 65,535 bytes \(i.e., 64 KB - 1 byte\);

        -   Data of BLOB type must be smaller than 64 MB, otherwise it will be truncated to 67,108,863 bytes \(i.e., 64 MB - 1 byte\);

        -   Data of SYMBOL type must be smaller than 255 bytes, otherwise the system will throw an exception.

    **Note**: Data exceeding these limits that has already been stored in the databases can still be accessed.

-   ANY DICTIONARY is the data type in DolphinDB for JSON.

-   COMPRESSED can only be generated with function [compress](../../../Functions/c/compress.md) .

-   The DURATION type can be generated with function `duration` or by combining an integer with a unit of time \(case sensitive\): y, M, w, d, B, H, m, s, ms, us, ns. The range of a DURATION value is -2 31 +1~2 31 -1. If a data type overflow occurs, the data is treated as null value.

-   DolphinDB uses IEEE 754 standard for the data types DOUBLE and FLOAT. If a data type overflow occurs, the data is treated as null value.

-   The character "S" of DECIMAL32\(S\), DECIMAL64\(S\) and DECIMAL128\(S\) means scale, which determines the number of digits to the right of the decimal point. The value range of S is \[0,9\] for DECIMAL32\(S\), \[0,18\] for DECIMAL64\(S\), and \[0,38\] for DECIMAL128\(S\). DECIMAL32 is stored as the int32\_t type and takes 4 bytes; DECIMAL64 is stored as the int64\_t type and takes 8 bytes; DECIMAL128 is stored as the int128\_t type and takes 16 bytes. DECIMAL\(0\) can represent integers in the range of \[-999,999,999, 999,999,999\], while the 4-byte integer \(INT32\) is in the range of \[-2,147,483,648, 2,147,483,647\]. Therefore, if the integral range of a numeric value exceeds the valid range of DECIMAL32 but is within the range of \[-2147483648, 2147483647\], it can still be converted to DECIMAL 32. However, when converting a string to DECIMAL32, if its length exceeds the range, the system raises an exception.

    ``` {#codeblock_fmz_s1y_jxb}
    decimal32(1000000000, 0)
                // output
                1000000000
                
                decimal32(`1000000000, 0)
                // output
                Convert string to DECIMAL failed: Decimal math overflow
    ```

-   In DolphinDB, INSTRUMENT and MKTDATA are data types designed to represent financial instruments and market data. They are subject to the following restrictions:

    -   When creating a distributed table containing INSTRUMENT or MKTDATA columns, only the TSDB storage engine is supported.

    -   Columns of type INSTRUMENT or MKTDATA cannot be used as primary keys in `keyedTable`, `indexedTable`, `keyedStreamTable`, `latestKeyedTable`, `latestIndexedTable`, or `latestKeyedStreamTable`.

    -   INSTRUMENT and MKTDATA types do not support unary or binary operators.


## Type check {#section_r4n_yby_jxb .section}

Use functions [typestr](../../../Functions/t/typestr.md) and [type](../../../Functions/t/type.md) to check data types. The function `typestr` returns a string; the function `type` returns an integer.

``` {#codeblock_p3d_cdy_jxb}
typestr 3l;
// output
LONG

type 3l;
// output
5

x=3;
if(type(x) == INT){y=10};
y;

// output
10
```

## Data Range {#section_fcm_ddy_jxb .section}

The range for integral data types are listed in the table above. For each of them, the mininum allowed value minus 1 represents the corresponding null value. For example, -128c is a null character. For null values please see [Null Value Manipulation](../../DataManipulation/NullValueManipulation/NullValueManipulation.md).

``` {#codeblock_hlb_kdy_jxb}
x=-128c;
x;
// output
00c
typestr x;
// output
CHAR
```

## Data Type Symbols {#section_bqr_ldy_jxb .section}

A data type symbol is used for declaring a data type of a constant. In the example below, without specifying a data type symbol, number 3 is stored in memory by default as an integer. If you would like to save it as a floating number, it should be declared as 3f\(float\) or 3F\(double\).

``` {#codeblock_hlq_mdy_jxb}
typestr 3;
// output
INT

typestr 3f;
// output
FLOAT

typestr 3F;
// output
DOUBLE

typestr 3l;
// output
LONG

typestr 3h;
// output
SHORT

typestr 3c;
// output
CHAR

typestr 3b;
// output
BOOL
```

``` {#codeblock_zn1_dfr_jzb}
typestr 3;
// output
INT

typestr 3f;
// output
FLOAT

typestr 3F;
// output
DOUBLE

typestr 3l;
// output
LONG

typestr 3h;
// output
SHORT

typestr 3c;
// output
CHAR

typestr 3b;
// output
BOOL

typestr 3P;
// output
DECIMAL64
```

## Symbol and String {#section_m55_ndy_jxb .section}

In some circumstances it might be optimal to save strings as SYMBOL types in DolphinDB. SYMBOL types are stored as integers in DolphinDB to allow more efficient sorting and comparison. Therefore, SYMBOL types could potentially improve operating performance and save storage space. On the other hand, mapping strings to integers \(hashing\) takes time and the hash table consumes memory.

The following rules could help you decide whether to use SYMBOL types or not:

-   Avoid using SYMBOL types if the data will not be sorted, searched or compared.

-   Avoid using SYMBOL types if there are few duplicate values.

Two specific cases:

-   Stock tickers in a trades or quotes table should use SYMBOL types because a stock usually has a large amount of rows in these tables, and because stocks tickers are frequently searched and compared.
-   Descriptive fields should not use SYMBOL types because description seldom repeats and is rarely searched, sorted or compared.

*Example 1:* Sorting a symbol vector with 3 million records is 40 times faster than that of the same sized string vector.

``` {#codeblock_vsl_ydy_jxb}
n=3000000
strs=array(STRING,0,n)
strs.append!(rand(`IBM`C`MS`GOOG, n))
timer sort strs;
// Time elapsed: 482.027 ms
            
n=3000000
syms=array(SYMBOL,0,n)
syms.append!(rand(`IBM`C`MS`GOOG, n))
timer sort syms;
// Time elapsed: 12.001 ms
```

*Example 2:* Comparing a symbol vector with 3 million records is almost 15 times as fast as comparing the same sized string vector.

``` {#codeblock_ogf_12y_jxb}
timer(100){strs>`C};
// Time elapsed: 4661.26 ms
            
timer(100){syms>`C};
// Time elapsed: 322.655 ms
```

## Integer Overflow {#integer_overflow .section}

An overflow occurs when the result of an operation falls outside the valid range of the data type being used. In DolphinDB, an integer overflow returns null.

In the following example, the variable x is of INT type, and it is assigned the maximum INT value, i.e., 2 31 - 1. The result of `x+1` exceeds the upper limit of the INT type, therefore it returns NULL.

```
x=(pow(2,31)-1)$INT;
x+1;
// output: null
```

