# Temporal Objects Manipulation {#temporal-objects-manipulation}

To get a part of a temporal variable:

```
year(2016.02.14);
// output: 2016

monthOfYear(2016.02.14);
// output: 2

dayOfMonth(2016.02.14);
// output: 14

x=01:02:03.456;
hour(x);
// output: 1

minuteOfHour(x);
// output: 2

secondOfMinute(x);
// output: 3

x mod 1000;
// output: 456
```

To adjust the value of a temporal variable with an amount in the same time unit, we can use operators '+' or '-':

```
2016.02M-13;
// output: 2015.01M

2018.02.17+100;
// output: 2018.05.28

01:20:15+200;
// output: 01:23:35
```

For temporal objects of data type minute, second, time, and nanotime, the internal integers representing these objects have a lower limit of zero and an upper limit of 1440-1, 86400-1, 86400000-1, and 86400000000000-1 respectively. If the internal integer representing one of these objects after adjustment is below 0 or above the corresponding upper limit, the final result corresponds to the remainder of dividing the internal integer by the corresponding upper limit.

```
23:59m+10;
// output: 00:09m

00:00:01-2;
// output: 23:59:59

23:59:59.900+200;
// output: 00:00:00.100
```

To adjust the value of a temporal variable with an amount in the same or a different time unit, we can use function [temporalAdd](../../../Functions/t/temporalAdd.md)

```
temporalAdd(2017.01.16,1,"w");
// output: 2017.01.23

temporalAdd(2016.12M,2,"M");
// output: 2017.02M

temporalAdd(13:30m,-15,"m");
// output: 13:15m
```

**Parent topic:**[Temporal Objects](../../../Programming/DataManipulation/TemporalObjects/TemporalObjects.md)

