# String Objects {#string-objects}

Strings in DolphinDB use UTF-8 character encoding. We also have the following functions that support the use of regular expressions: [regexFind](../../../Functions/r/regexFind.md), [regexReplace](../../../Functions/r/regexReplace.md), [regexCount](../../../Functions/r/regexCount.md).

Note that regular expression standards used by DolphinDB vary depending on the operating system, as follows:

-   For Linux, Extended Regular Expressions \(ERE\) based on the POSIX standard is employed.

-   For Windows, ERE based on the C++ standard library is used.


-   **[Create Strings](../../../Programming/DataManipulation/StringObjects/CreateStrings.md)**  

-   **[Search in Strings](../../../Programming/DataManipulation/StringObjects/SearchinStrings.md)**  

-   **[String Operations](../../../Programming/DataManipulation/StringObjects/StringOperations.md)**  


**Parent topic:**[Data Manipulation](../../../Programming/DataManipulation/DataManipulation.md)

