# Create Strings {#create-strings}

We can use the following ways to create a string:

\(1\) Use single quotes \('\), double quotes \("\), or back quotes \(\`\).

A few things to notice:

-   Back quotes are very convenient, but they cannot be used for strings that contain spaces or symbols.

-   To create a string with only one character, we can use back quotes or double quotes but not single quotes. Single quotes around one character create a CHAR instead of STRING.


```
var1='DolphinDB version 1.1';
var2="This is DolphinDB";
var3=`DolphinDB;
var4=['IBM', 'MSFT', 'GOOG', 'FB'];
var5=["IBM","MSFT","GOOG","FB"];
var6=`IBM`MSFT`GOOG`FB;
typestr(`C);
// output: STRING

typestr("C");
// output: STRING

typestr('C');
// output: CHAR
```

\(2\) Use function [string](../../../Functions/s/string.md).

```
var7=string(108.5);
```

\(3\) Use function [format](../../../Functions/f/format.md). It applies a specified format to the given object to produce a string scalar/vector. Depending on the data type of the input, function `format` calls either function [decimalFormat](../../../Functions/d/decimalFormat.md) or [temporalFormat](../../../Functions/t/temporalFormat.md).

```
t = table(1..100 as id, (1..100 + 2018.01.01) as date, rand(100.0, 100) as price, rand(10000, 100) as qty);
t;
```

|id|date|price|qty|
|---|----|-----|---|
|1|2018.01.02|70.832104|1719|
|2|2018.01.03|12.22557|6229|
|3|2018.01.04|8.695886|1656|
|4|2018.01.05|24.324535|2860|
|5|2018.01.06|0.443173|6874|
|6|2018.01.07|90.302176|3277|
|7|2018.01.08|78.556843|3424|
|8|2018.01.09|45.836447|8636|
|9|2018.01.10|57.416425|707|
|10|2018.01.11|98.879764|2267|
|...|...|...|...|

```
t1=select id, date.format("MM/dd/yyyy") as date, price.format("00.00") as price, qty.format("#,###") as qty from t;
t1;
```

|id|date|price|qty|
|---|----|-----|---|
|1|01/02/2018|70.83|1,719|
|2|01/03/2018|12.23|6,229|
|3|01/04/2018|08.70|1,656|
|4|01/05/2018|24.32|2,860|
|5|01/06/2018|00.44|6,874|
|6|01/07/2018|90.30|3,277|
|7|01/08/2018|78.56|3,424|
|8|01/09/2018|45.84|8,636|
|9|01/10/2018|57.42|707|
|10|01/11/2018|98.88|2,267|
|...|...|...|...|

```
t1.date.typestr();
// output: STRING VECTOR
```

The following table shows the symbols used in the parameter format of function `decimalFormat`. Please check the section [Parsing and Format of Temporal Variables](../TemporalObjects/ParsingandFormatofTemporalVariables.md) regarding the parameter format of function `temporalFormat`.

|Symbol|Meaning|Notes|
|------|-------|-----|
|0|mandatory digit|note 1|
|\#|optional digit|note 2|
|.|decimal point||
|%|percent sign|note 3|
|E|separates mantissa and exponent in scientific notation.|note 4|
|,|grouping separator|note 5|
|;|separates the format for positive numbers and the format for negative numbers|note 6|

-   Note 1: The number of 0s before the decimal point means the minimum number of digits before the decimal point. In comparison, the number of 0s after the decimal point means the number of digits after the decimal point.


```
decimalFormat(123,"0");
// output: 123

decimalFormat(123,"00000");
// output: 00123

decimalFormat(123.45,"0");
// output: 123

decimalFormat(123.45,"0.0");
// output: 123.5

decimalFormat(123.45,"0.000");
// output: 123.450

decimalFormat(123.45, ".0");
// output: 123.5

decimalFormat(0.45, ".0");
// output: .5
```

-   Note 2: If 0s and \#s are used together after the decimal point, 0s must appear before \#s.


```
decimalFormat(123.45,"0.#");
// output: 123.5

decimalFormat(123.45,"0.###");
// output: 123.45

decimalFormat(123.456,"0.000###");
// output: 123.456

decimalFormat(123.456789110,"0.000###");
// output: 123.456789

decimalFormat(0.345, ".##");
// output: .35
```

-   Note 3: % is always at the end of a format. % and E cannot both appear in a format.


```
decimalFormat(0.125,"0.00%");
// output: 12.50%

decimalFormat(0.125, "#.##%");
// output: 12.5%

decimalFormat(0.12567,"#.##%");
// output: 12.57%
```

-   Note 4: "E" is followed by at least one 0 and 0s only.


```
decimalFormat(1234567.89,"0.##E00");
// output: 1.23E06

decimalFormat(0.0000000000123456789,"0.000E0");
// output: 1.235E-11
```

-   Note 5: The grouping separator may only appear at most once in the parameter format. The number of digits between the grouping separator and the decimal point \(if the decimal point is used\) or the end of the format \(if the decimal point is not used\) determines the number of digits between grouping separators in the result.


```
decimalFormat(123456789,"#,###");
// output: 123,456,789

decimalFormat(123456789.166,"#,###.##");
// output: 123,456,789.17

decimalFormat(123456789.166,"0,000.00");
// output: 123,456,789.17
```

-   Note 6: If we prefer to apply different formats to an object depending on whether it is positive or negative, we can use ";" to seperate the 2 formats.


```
decimalFormat(123.456,"0.00#E00;(0.00#E00)");
// output: 1.235E02

decimalFormat(-123.456,"0.00#E00;(0.00#E00)");
// output: (1.235E02)
```

\(4\) Use the escape character.

|Use of the escape character|Meaning|
|---------------------------|-------|
|\\n|new line|
|\\r|carriage return|
|\\t|tab|
|\\|backslash|
|'|single quote|
|"|double quote|

```
x="ABC\\DEF";
x;
// output: ABC\DEF

x="ABC\"D\'EF";
x;
// output: ABC"D'EF
```

If a string only contains one type of quotes \(single quotes or double quotes\), the simplest way to create it is to use the other type of quotes.

```
x="ABC'D'EF";
x;
// output: ABC'D'EF

x='ABC"DEF';

/* output
4 x;
ABC"DEF
*/
```

**Parent topic:**[String Objects](../../../Programming/DataManipulation/StringObjects/StringObjects.md)

