# Replace Null Values {#replace-null-values}

To replace null values, we can use the following functions:

1.  [bfill](../../../Functions/b/bfill.md) and [bfill!](../../../Functions/b/bfill!.md) : back fill the null values with the next non-null value.

2.  [ffill](../../../Functions/f/ffill.md) and [ffill!](../../../Functions/f/ffill!.md) : forward fill the null values with the previous non-null value.

3.  [lfill](../../../Functions/l/lfill.md) and [lfill!](../../../Functions/l/lfill!.md) : linearly fill the null values between 2 non-null values.

4.  [nullFill](../../../Functions/n/nullFill.md) and [nullFill!](../../../Functions/n/nullFill!.md) : fill the null values with a prescribed value.


For both `bfill` and `ffill`, we can use an optional parameter limit to limit the number of null values to fill for each block of null values.

**Parent topic:**[Null Value Manipulation](../../../Programming/DataManipulation/NullValueManipulation/NullValueManipulation.md)

## Example 1: {#example-1}

```
ID=take(1,6) join take(2,6)
date=take(2018.01.01..2018.01.06, 12)
x=3.2 5.2 NULL 7.4 NULL NULL NULL NULL 8 NULL NULL 11
t=table(ID, date, x);
t;
```

|ID|date|x|
|---|----|---|
|1|2018.01.01|3.2|
|1|2018.01.02|5.2|
|1|2018.01.03||
|1|2018.01.04|7.4|
|1|2018.01.05||
|1|2018.01.06||
|2|2018.01.01||
|2|2018.01.02||
|2|2018.01.03|8|
|2|2018.01.04||
|2|2018.01.05||
|2|2018.01.06|11|

```
update t set x=x.lfill() context by id;
t;
```

|ID|date|x|
|---|----|---|
|1|2018.01.01|3.2|
|1|2018.01.02|5.2|
|1|2018.01.03|6.3|
|1|2018.01.04|7.4|
|1|2018.01.05||
|1|2018.01.06||
|2|2018.01.01||
|2|2018.01.02||
|2|2018.01.03|8|
|2|2018.01.04|9|
|2|2018.01.05|10|
|2|2018.01.06|11|

```
update t set x=x.bfill(1) context by id;
t;
```

|ID|date|x|
|---|----|---|
|1|2018.01.01|3.2|
|1|2018.01.02|5.2|
|1|2018.01.03|6.3|
|1|2018.01.04|7.4|
|1|2018.01.05||
|1|2018.01.06||
|2|2018.01.01||
|2|2018.01.02|8|
|2|2018.01.03|8|
|2|2018.01.04|9|
|2|2018.01.05|10|
|2|2018.01.06|11|

```
update t set x=x.bfill() context by id;
t;
```

|ID|date|x|
|---|----|---|
|1|2018.01.01|3.2|
|1|2018.01.02|5.2|
|1|2018.01.03|6.3|
|1|2018.01.04|7.4|
|1|2018.01.05||
|1|2018.01.06||
|2|2018.01.01|8|
|2|2018.01.02|8|
|2|2018.01.03|8|
|2|2018.01.04|9|
|2|2018.01.05|10|
|2|2018.01.06|11|

```
update t set x=x.ffill() context by id;
t;
```

|ID|date|x|
|---|----|---|
|1|2018.01.01|3.2|
|1|2018.01.02|5.2|
|1|2018.01.03|6.3|
|1|2018.01.04|7.4|
|1|2018.01.05|7.4|
|1|2018.01.06|7.4|
|2|2018.01.01|8|
|2|2018.01.02|8|
|2|2018.01.03|8|
|2|2018.01.04|9|
|2|2018.01.05|10|
|2|2018.01.06|11|

## Example2: {#example2}

```
ID=take(1,6) join take(2,6)
date=take(2018.01.01..2018.01.06, 12)
x=3.2 5.2 NULL 7.4 NULL NULL NULL NULL 8 NULL NULL 11
t=table(ID, date, x);
t;
```

|ID|date|x|
|---|----|---|
|1|2018.01.01|3.2|
|1|2018.01.02|5.2|
|1|2018.01.03||
|1|2018.01.04|7.4|
|1|2018.01.05||
|1|2018.01.06||
|2|2018.01.01||
|2|2018.01.02||
|2|2018.01.03|8|
|2|2018.01.04||
|2|2018.01.05||
|2|2018.01.06|11|

```
update t set x=x.nullFill(avg(x)) context by id;
t;
```

|ID|date|x|
|---|----|---|
|1|2018.01.01|3.2|
|1|2018.01.02|5.2|
|1|2018.01.03|5.266667|
|1|2018.01.04|7.4|
|1|2018.01.05|5.266667|
|1|2018.01.06|5.266667|
|2|2018.01.01|9.5|
|2|2018.01.02|9.5|
|2|2018.01.03|8|
|2|2018.01.04|9.5|
|2|2018.01.05|9.5|
|2|2018.01.06|11|

