# Vector/Set/Tuple with Null Values {#vectorsettuple-with-nulls}

Vectors with null values:

```
x=1 2 NULL NULL 3;
y=2 NULL NULL 3 4;
x+y;
// output: [3,,,,7]

x*y;
// output: [2,,,,12]

x**y;
// output: 14
// inner product

sum x;
// output: 6

x<y;
// output: [1,0,0,1,1]

x||1;
// output: [1,1,,,1]

// a binary operation on null values returns NULL except relational operators such as <, <=, etc
```

Sets with null values:

```
a=set(1 NULL)
b=set(2 NULL);
x=a&b;
x;
// output: set(00i)

// the common element between x and y is NULL
NULL in x;
// output: 1
size(x);
// output: 1

// set x is not empty: it has a null element
c=set(2 3);
y=a&c;
y;
// output: set()

size(y);
// output: 0

// this is the only function to check whether a set is empty
```

Tuples with null values:

```
x=(1, NULL);
x+1;
// output: (2,)
```

**Parent topic:**[Null Value Operations](../../../../Programming/DataManipulation/NullValueManipulation/NullValueOperation/NullValueOperation.md)

