# Null Value Initialization {#null-initialization}

This section introduces how to initialize null values of VOID type and a specified numeric type.

**Parent topic:**[Null Value Manipulation](../../../Programming/DataManipulation/NullValueManipulation/NullValueManipulation.md)

## Null Values of VOID Type {#topic_hdk_sxr_5dc}

VOID type can only be applied to scalars. VOID vectors cannot be directly created.

``` {#codeblock_xlx_5hn_ryb}
x=NULL;
typestr x;
// output: VOID

take(NULL, 4);
// output: Not allowed to create void vector
```

VOID columns cannot be added to a table.

``` {#codeblock_zlx_5hn_ryb}
t = table(rand(10,10) as x)
addColumn(t, `col1, VOID)
Invalid data type: 0
t[`col1]=NULL
Not allowed to create void vector
```

To add a VOID column to a table, use a `select` statement with `NULL`.

``` {#codeblock_bmx_5hn_ryb}
tmp=select *, NULL from t
typestr(tmp[`NULL])
VOID VECTOR
```

## Null Values of a Numeric Type {#topic_exl_4zr_5dc}

To initialize null temporal scalars or null values of integral/floating type, use 00&lt;data type symbol&gt;.

To initialize null vectors, use [take](https://docs.dolphindb.cn/en/Functions/t/take.html) \(00&lt;data type symbol&gt;, *n*\), where *n* is the number of elements in the vector.

``` {#codeblock_jpq_zmb_ndc}
x=00b;
// b indicates a BOOL constant
typestr x;
// output: BOOL

bool();
// output: 00b
// Use type functions such as bool, char, short, int to create a null scalar if no argument is provided

x=00i;
// i indicates a INT constant

typestr x;
// output: INT

x=00l;
// l indicates a LONG constant

typestr x;
// output: LONG

x=take(00b, 10);
// Initialize a null BOOL vector with 10 elements

x;
// output: [,,,,,,,,,]

typestr x;
// output: FAST BOOL VECTOR

x=take(00i, 10)
// Initialize a null INT vector with 10 elements

x;
// output: [,,,,,,,,,]

x=array(INT, 10, 100, NULL);
// Initialize a null INT vector with 10 elements and an initial size of 100

x;
// output: [,,,,,,,,,]

x=true false NULL true;
x;
// output: [1,0, ,1]

m=matrix(DOUBLE,3,3)*NULL;
m;
```

|\#0|\#1|\#2|
|---|---|---|
||||

``` {#codeblock_lpq_zmb_ndc}
shape m;
// output: 3:3

typestr m;
// output: DOUBLE MATRIX
```

