# Detect Null Values {#detect-null-values}

Functions [isNull](../../../Functions/i/isNull.md) or [hasNull](../../../Functions/h/hasNull.md) detect null values. `isNull` returns a scalar or a vector depending on the input data; `hasNull` always returns 0 or 1 indicating if an object contains at least one null value.

```
isNull(00i);
// output: 1

isNull(-128c);
// output: 1
// the minimum char is reserved for null value

isNull(1 NULL 2);
// output: [0,1,0]

hasNull(1 NULL 2);
// output: 1
```

**Parent topic:**[Null Value Manipulation](../../../Programming/DataManipulation/NullValueManipulation/NullValueManipulation.md)

