# zscore {#zscore}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`zscore(X)`

## Arguments {#arguments}

**X** is a vector/matrix.

## Details {#details}

If *X* is a vector, return the zscore for all elements of *X*.

If *X* is a matrix, the zscore calculation is conducted within each column of *X*.

As with all aggregate functions, null values are not included in the calculation.

Please note that the calculation uses sample standard deviation instead of population standard deviation.

## Examples {#examples}

```
zscore(1 2 3 4 5);
// output: [-1.264911,-0.632456,0,0.632456,1.264911]

m=matrix(1 2 3, 4 5 6);
m;
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|
|3|6|

```
zscore(m);
```

|\#0|\#1|
|---|---|
|-1|-1|
|0|0|
|1|1|

