# zTest {#ztest}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`zTest(X, [Y], [mu=0.0], [sigmaX=1.0], [sigmaY=1.0], [confLevel=0.95])`

## Arguments {#arguments}

**X** is a numeric vector indicating the sample for the Z-test.

**Y** \(optional\) is a numeric vector indicating the second sample for a paired-sample Z-test. It is optional.

**mu** \(optional\) is a floating number. If *Y* is not specified, *mu* is the mean value of *X* in the null hypothesis; if *Y* is specified, *mu* is the difference in the mean values of *X* and *Y* in the null hypothesis. It is optional and the default value is 0.

**sigmaX** \(optional\) is a floating number indicating the standard deviation of *X*. It is optional and the default value is 1.

**sigmaY** \(optional\) is a floating number indicating the standard deviation of *Y*. It is optional and the default value is 1.

**confLevel** \(optional\) is a floating number between 0 and 1 indicating the confidence level of the test. It is optional and the default value is 0.95.

## Details {#details}

If *Y* is not specified, conduct a one-sample Z-test on *X*. If *Y* is specified, conduct a paired-sample Z-test on *X* and *Y*.

Return a dictionary with the following keys:

-   stat: a table with p-value and confidence interval under 3 alternative hypotheses.

-   confLevel: confidence level

-   method: "One sample Z-test" if *Y* is not specified; "Two sample Z-test" if *Y* is specified.

-   zValue: Z-stat


## Examples {#examples}

One-sample Z-test:

```
x = norm(5.0, 2.0, 30)
zTest(x, , 5.0, 2.0);

/* output:
stat->

alternativeHypothesis       pValue   lowerBound upperBound
--------------------------- -------- ---------- -----------
true mean is not equal to 5 0.035765 3.517659   4.949014
true mean is less than 5    0.017882 -Infinity  4.833952
true mean is greater than 5 0.982118 3.632721   Infinity

confLevel->0.95
method->One sample z-test
zValue->-2.099594
*/
```

Paired-sample Z-test:

```
x = norm(5.0, 2.0, 30)
y = norm(10.0, 3.0, 40)
zTest(x, y, -5.0, 2.0, 3.0);

/* output:
stat->

------------------------------------- -------- ---------- -----------
alternativeHypothesis                 pValue   lowerBound upperBound
difference of mean is not equal to -5 0.976133 -6.191162  -3.844655
difference of mean is less than -5    0.488067 -Infinity  -4.033283
difference of mean is greater than -5 0.511933 -6.002533  Infinity

confLevel->0.95
method->Two sample z-test
zValue->-0.029917
*/
```

