# yearBegin {#yearbegin}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`yearBegin(X, [startingMonth=1], [offset], [n=1])`

## Arguments {#arguments}

**X** is a scalar/vector of data type DATE, DATEHOUR, DATETIME, TIMESTAMP or NANOTIMESTAMP.

**startingMonth** \(optional\) is an integer between 1 and 12 indicating a month. The default value is 1.

**offset** \(optional\) is a scalar of the same data type as *X*. It must be no greater than the minimum value of *X*. The default value is the minimum value of *X*.

**n** \(optional\) is a positive integer. The default value is 1.

## Details {#details}

Return the first day of the year that *X* belongs to and that starts in the month of *startingMonth*.

If parameter *offset* is specified, the result is updated every *n* years. The parameters *offset* and *n* must be specified together, and *offset* takes effect only when *n* &gt; 1.

## Examples {#examples}

```
yearBegin(2012.06.12, 10);
// output: 2011.10.01

yearBegin(2012.06.12, 4);
// output: 2012.04.01

yearBegin(2012.06.12);
// output: 2012.01.01

yearBegin(2012.06.12, 1, 2009.04.03, 2);
// output: 2011.01.01

date=2011.04.25+(1..10)*365
time = take(09:30:00, 10);
sym = take(`MSFT,10)
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29 52.38
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800 4500
t1 = table(date, time, sym, qty, price);

t1;
```

|date|time|sym|qty|price|
|----|----|---|---|-----|
|2012.04.24|09:30:00|MSFT|2200|49.6|
|2013.04.24|09:30:00|MSFT|1900|29.46|
|2014.04.24|09:30:00|MSFT|2100|29.52|
|2015.04.24|09:30:00|MSFT|3200|30.02|
|2016.04.23|09:30:00|MSFT|6800|174.97|
|2017.04.23|09:30:00|MSFT|5400|175.23|
|2018.04.23|09:30:00|MSFT|1300|50.76|
|2019.04.23|09:30:00|MSFT|2500|50.32|
|2020.04.22|09:30:00|MSFT|8800|51.29|
|2021.04.22|09:30:00|MSFT|4500|52.38|

```
select avg(price),sum(qty) from t1 group by yearBegin(date, 10, 2010.10.01, 2);
```

|yearBegin\_date|avg\_price|sum\_qty|
|---------------|----------|--------|
|2010.10.01|49.6|2200|
|2012.10.01|29.49|4000|
|2014.10.01|102.495|10000|
|2016.10.01|112.995|6700|
|2018.10.01|50.805|11300|
|2020.10.01|52.38|4500|

Related functions: [yearEnd](yearEnd.md), [businessYearBegin](../b/businessYearBegin.md), [businessYearEnd](../b/businessYearEnd.md)

