# writeLines {#writelines}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`writeLines(handle, object, [offset=0], [length], [windowsLineEnding])`

## Arguments {#arguments}

**length** is the number of lines from the handle to read.

## Details {#details}

Write a given number of lines to the handle.

## Examples {#examples}

```
timer(10){
   x=rand(`IBM`MSFT`GOOG`YHOO`ORCL,10240)
   eachRight(writeLine, file("test.txt","w"),x)
   fin = file("test.txt")
   do{ y=fin.readLine() } while(!y.isVoid())
    fin.close()
};

// Time elapsed: 277.548 ms

timer(10){
   x=rand(`IBM`MSFT`GOOG`YHOO`ORCL,10240)
   file("test.txt","w").writeLines(x)
   fin = file("test.txt")
   do{ y=fin.readLines(1024) } while(y.size()==1024)
   fin.close()
};

// Time elapsed: 28.003 ms
```

