# writeLine {#writeline}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`writeLine(handle, line, [windowsLineEnding])`

## Arguments {#arguments}

**handle** is a handle object that points to the target file or socket.

**line** is a STRING scalar, indicating a line of text to be written, without requiring a newline character at the end.

**windowsLineEnding** \(optional\) is a Boolean variable that indicates whether to force the use of Windows-style line endings \(\\r\\n\). If the parameter is not specified, the line ending character would be:

-   \\r\\n if *handle* is a socket

-   \\n if *handle* is a file and the operation system is not Windows

-   \\r\\n if *handle* is a file and the operating system is Windows


## Details {#details}

Write a line to the given handle. The function will automatically append a line delimiter to the string. Thus the string shouldn't end with a line delimiter. If the operation succeeds, it returns 1; otherwise, an IOException will be raised.

## Examples {#examples}

```
x=`IBM`MSFT`GOOG`YHOO`ORCL
eachRight(writeLine, file("test.txt","w"), x);
// output: [1,1,1,1,1]

fin = file("test.txt")
do{
   x=fin.readLine()
   if(x.isVoid()) break
   print x
}
while(true);

/* output:
IBM
MSFT
GOOG
YHOO
ORCL
*/
```

