# write {#write}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`write(handle, object, [offset=0], [length])`

## Details {#details}

Convert the specified buffer to a stream of bytes and then save to the file. The buffer could be a scalar or a vector with various data types. If an error occurs, an IOException is raised. Otherwise, the function returns the number of elements \(not the number of bytes\) written.

The `read!` function reads a given number of elements to the buffer. For example, if the buffer is an INT vector, the function will convert the bytes from the file to INT. Both `write` and `read!` function involve the conversion between streams of bytes and multi-byte words, which is termed as endianness in computer science. The big endianness has the most significant byte in the lowest address whereas the little endianness has the least significant byte in the lowest address. The `write` function always uses the endianness of the operating system. The `read!` function can convert the endianness if the endianness of the file is different from the one of the operating system. When one uses the `file` function to open a file, there is an optional boolean argument to indicate if the file adopts the little endian format. By default, it is the endianness of the operating system.

## Examples {#examples}

```
x=10h
y=0h
file("test.bin","w").write(x);
// output: 1

file("test.bin","r",true).read!(y);
// output: 1

// assume the file format is little endianness
y;
// output: 10

file("test.bin","r",false).read!(y);
// output: 1

// assume the file format is big endianness
y;
// output: 2560
```

