# wma {#wma}

## Syntax {#syntax}

`wma(X, window)`

Please see [TALib](../Themes/TALib.md) for the parameters and windowing logic.

## Details {#details}

Calculate the Weighted Moving Average \(wma\) for *X* in a sliding window of the given length.

The formula is: ![](../../images/wma.png)

## Examples {#examples}

```
x=12.1 12.2 12.6 12.8 11.9 11.6 11.2
wma(x,3);
// output: [,,12.383333333333332,12.633333333333334,12.316666666666668,11.9,11.450000000000001]

x=matrix(12.1 12.2 12.6 12.8 11.9 11.6 11.2, 14 15 18 19 21 12 10)
wma(x,3);
```

|col1|col2|
|----|----|
|||
|||
|12.3833|16.3333|
|12.6333|18|
|12.3167|19.8333|
|11.9|16.1667|
|11.45|12.5|

Related functions: [sma](../s/sma.md), [trima](../t/trima.md)

