# weekday {#weekday}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`weekday(X, [startFromSunday=true])`

## Arguments {#arguments}

**X** is a temporal scalar/vector.

**startFromSunday** \(optional\) is a Boolean value indicating whether a week starts from Sunday. The default value is true. If *startFromSunday*=false, a week starts from Monday.

## Details {#details}

Return integer\(s\) to represent of the corresponding weekday\(s\) of *X*.

If *startFromSunday*=true, 0 means Sunday, 1 means Monday, ..., and 6 means Saturday.

If *startFromSunday*=false, 0 means Monday, 1 means Tuesday, ..., and 6 means Sunday.

## Examples {#examples}

```
weekday 2012.12.05;
// output: 3

weekday(2012.12.05, false);
// output: 2

weekday 2013.05.23T12:00:00;
// output: 4

weekday(2014.01.11T23:04:28.113);
// output: 6

weekday 2012.12.05 2012.12.06 2013.01.05;
// output: [3,4,6]
```

