# weekOfYear {#weekofyear}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`weekOfYear(X)`

## Arguments {#arguments}

**X** is a scalar/vector of type DATE, DATETIME, TIMESTAMP or NANOTIMESTAMP.

## Details {#details}

Return the week number for *X*.

Note:

-   Each week starts on Sunday. The first week of the year has more than 4 days.

-   If 31 December is on a Monday, Tuesday or Wednesday, it is in week 01 of the next year. If it is on a Thursday, it is in week 53 of the year just ending; if on a Friday it is in week 52 \(or 53 if the year just ending is a leap year\); if on a Saturday or Sunday, it is in week 52 of the year just ending.

## Examples {#examples}

```
weekOfYear(2012.01.07);
// output: 1

weekOfYear(2013.01.07);
// output: 2

weekOfYear(2012.07.02);
// output: 27

weekOfYear([2012.06.12T12:30:00,2012.10.28T12:35:00,2013.01.06T12:36:47,2013.04.06T08:02:14]);
// output: [24,43,1,14]
```

Related function: [dayOfYear](../d/dayOfYear.md), [dayOfMonth](../d/dayOfMonth.md), [quarterOfYear](../q/quarterOfYear.md), [monthOfYear](../m/monthOfYear.md), [hourOfDay](../h/hourOfDay.md), [minuteOfHour](../m/minuteOfHour.md), [secondOfMinute](../s/secondOfMinute.md), [millisecond](../m/millisecond.md), [microsecond](../m/microsecond.md), [nanosecond](../n/nanosecond.md)

