# warmupStreamEngine {#warmupstreamengine}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`warmupStreamEngine(engine, msgs)`

## Arguments {#arguments}

**engine** is the table object returned from creating a stream engine.

**msgs** is a table.

## Details {#details}

Ingest data into a stream engine without outputting results. When the next batch of data is ingested, the calculation can be sped up with the results that have already been generated.

Currently it only supports the reactive state engine, and \(daily\) time series engine.

## Examples {#examples}

```
trade=table(1000:0, `date`sym`price`volume, [DATE, SYMBOL, DOUBLE, INT])
n=3000*100
date=take(2021.03.08, n)
sym=take("A"+string(1..3000), n)
price=round(rand(100.0, n), 2)
volume=rand(100, n)
table1 = table(date, sym, price, volume)
outputTable = table(n:0, `sym`factor1, [STRING,DOUBLE])
engine = createReactiveStateEngine("test", <ema(volume, 40)>, table1, outputTable, "sym")
warmupStreamEngine(engine, table1)
date=take(2021.03.09, n)
sym=take("A"+string(1..3000), n)
price=round(rand(100.0, n), 2)
volume=rand(100, n)
table2 = table(date, sym, price, volume)
engine.append!(table2)
```

