# volumeBar {#volumebar}

## Syntax {#section_xmf_pvp_bzb .section}

`volumeBar(X, interval, [label='seq'])`

## Arguments {#section_pwz_pvp_bzb .section}

**X** is a numeric vector.

**interval** is a non-zero number that represents a constant value or percentage that determines the threshold for data grouping.

**label** \(optional\) is a string used to label the groups. It can be:

-   'seq'\(default\): label the groups with a sequence of 0, 1, 2, 3...

-   'left': label each group with the sum of all elements before the first element in the group. The first group is labeled with 0.

-   'right': label each group with the sum of all elements up to and including the last element in the group.


## Details {#section_xnm_rvp_bzb .section}

This function sequentially accumulates the elements in *X*, and then groups them based on the specified threshold. Once a group is determined, the accumulation starts from the next element and data grouping is performed in the same logic. It returns a vector of the same size as *X* containing the corresponding group number for each element.

Elements are divided into groups based on the threshold specified by *interval*.

-   If *interval* is positive, elements are labeled into groups when the cumulative sum is no smaller than the threshold;

    -   If *interval* is in \(0, 1\), the threshold is sum\(X\) \* *interval*. Note that the threshold is converted to the same data type as *X* for comparison. For example, if *X* is an integer, then the threshold will be set at floor\(sum\(X\) \* *interval*\).

    -   Otherwise, the threshold takes the value of *interval*.

-   If *interval* is negative, the threshold takes the value of *interval*. Elements are labeled into groups when the cumulative sum is no greater than the threshold.


## Examples {#section_zhl_svp_bzb .section}

``` {#codeblock_rcz_svp_bzb}
X =  1 3 4 2 2 1 1 1 1 6 8
volumeBar(X, 4)
// output: [0,0,1,2,2,3,3,3,3,4,5]

volumeBar(X, 4, 'left')
// output: [0,0,4,8,8,12,12,12,12,16,22]

volumeBar(X, 4, 'right')
// output: [4,4,8,12,12,16,16,16,16,22,30]

volumeBar(X, 0.3)
// output: [0,0,0,0,1,1,1,1,1,1,2]

X = -6 2 -4 -5 -1 3 -2 -1
volumeBar(X, -2)
// output: [0,1,1,2,3,3,3,3]
 
volumeBar(X, -2, 'left')
// output: [0,-6,-6,-8,-13,-13,-13,-13]

volumeBar(X, -2, 'right')
// output: [-6,-8,-8,-13,-14,-14,-14,-14]

sym = `st001`st002`st003`st001`st003`st004
time = 2022.01.01 2022.01.01 2022.01.02 2022.01.02 2022.01.03 2022.01.03
price = 1.9 2.2 1.8 1.1 2.5 1.9
t = table(sym, time, price)
select *, volumeBar(price, 3) as tag from t 
/* output:
sym	time	price	tag
st001	2022.01.01	1.9	0
st002	2022.01.01	2.2	0
st003	2022.01.02	1.8	1
st001	2022.01.02	1.1	1
st003	2022.01.03	2.5	1
st004	2022.01.03	1.9	2
*/
```

**Parent topic:**[Functions](../../Functions/category.md)

