# var {#var}

## Syntax {#syntax}

`var(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix.

## Details {#details}

If *X* is a vector, return the the \(unbiased\) sample standard variance of *X*.

If *X* is a matrix, calculate the the \(unbiased\) sample standard variance of each column of *X* and return a vector.

As with all aggregate functions, null values are not included in the calculation.

**Note:** The result is sample variance instead of population variance.

## Examples {#examples}

```
var(1 1 1);
// output: 0

var(1 2 3);
// output: 1

m=matrix(1 3 5 7 9, 1 4 7 10 13);
m;
```

|\#0|\#1|
|---|---|
|1|1|
|3|4|
|5|7|
|7|10|
|9|13|

```
var(m);
// output: [10,22.5]
```

Related functions: [covar](../c/covar.md) and [corr](../c/corr.md)

