# vanillaOption {#vanillaOption}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`vanillaOption(settlement, maturity, evalDate, spot, strike, riskFree, divYield, volatility, isCall, style, basis, calendar, [method="BS"], [kwargs], [mode=0])`

## Arguments {#arguments}

**Note:** Scalar inputs will be automatically expanded to match the length of other vector inputs. All vector inputs must be of equal length.

**settlement** is a DATE scalar or vector indicating the settlement date.

**maturity** is a DATE scalar or vector indicating the maturity date.

**evalDate**is a DATE scalar or vector indicating the evaluation date.

**spot** is a numeric scalar or vector indicating the spot price.

**strike** is a numeric scalar or vector indicating the strike price.

**riskFree** is a numeric scalar or vector indicating the risk-free interest rate.

**divYield** is a numeric scalar or vector indicating the dividend yield.

**volatility** is a numeric scalar or vector indicating the volatility.

**isCall** is a Boolean scalar or vector.

-   true: buy \(call option\)
-   false: sell \(put option\)

**style** is a STRING scalar or vector indicating the option exercise style. It can be 'european' or 'american'.

**calendar** is a STRING scalar or vector indicating the trading calendar\(s\). See [Trading Calendar](../../Tutorials/trading_calendar.md) for more information.

**method** \(optional\) is a STRING scalar indicating the pricing method:

-   'BS' \(default\): Black-Scholes model \(for European options only\).
-   'FDBS': Finite Difference method + Black-Scholes model.
-   'heston': Heston model \(for European options only\).
-   'FDHeston': Finite Difference method + Heston model.
-   'PTDHeston': Piecewise Time Dependent Heston model \(for European options only\).

**kwargs** \(optional\) is a dictionary specifying other required parameters. Leave it unspecified when *method*='BS'. The key-values pairs should be:

-   When *method*='FDBS':
    -   'xGrid': A scalar or vector with integers greater than 1, indicating the number of spatial grids used for discretization in the finite difference method.
    -   'tGrid': A scalar or vector with positive integers, indicating the number of time grids used for discretization in the finite difference method. *tGrid* must be greater than 0.
    -   'dampingSteps': A scalar or vector with non-negative integers, representing the number of damping steps applied in the finite difference solution process.
-   When *method*='heston':
    -   'theta': A numeric scalar or vector representing the long-term mean of the variance.
    -   'kappa': A numeric scalar or vector indicating the speed of mean reversion for the variance.
    -   'rho': A numeric scalar or vector representing the correlation coefficient between the asset price and volatility.
    -   'sigma': A numeric scalar or vector representing the volatility of volatility.
-   When *method*='FDHeston':
    -   'theta': A numeric scalar or vector representing the long-term mean of the variance.
    -   'kappa': A numeric scalar or vector indicating the speed of mean reversion for the variance.
    -   'rho': A numeric scalar or vector representing the correlation coefficient between the asset price and volatility.
    -   'sigma': A numeric scalar or vector representing the volatility of volatility.
    -   'xGrid': An scalar or vector with integers greater than 1, indicating the number of spatial grids used for discretization in the finite difference method.
    -   'vGrid': An scalar or vector with integers greater than 1, indicating the number of volatility grids used for discretization in the finite difference method.
    -   'tGrid': An scalar or vector with positive integers, indicating the number of time grids used for discretization in the finite difference method. *tGrid* must be greater than 0.
    -   'dampingSteps': An scalar or vector with non-negative integers, representing the number of damping steps applied in the finite difference solution process.
-   When *method*='PTDHeston':
    -   'times': A numeric vector or array indicating the time points when conditions change.
    -   'theta': A numeric scalar or vector representing the long-term mean of the variance.
    -   'kappa': A numeric scalar or vector indicating the speed of mean reversion for the variance.
    -   'rho': A numeric scalar or vector representing the correlation coefficient between the asset price and volatility.
    -   'sigma': A numeric scalar or vector representing the volatility of volatility.

**mode** \(optional\) is an integeralscalar or vector indicating the output mode:

-   0 \(default\): NPV \(net present value\) only.
-   1: NPV and Greeks \(delta, gamma, theta, vega and rho\) in a nested tuple.
-   2: NPV and Greeks \(delta, gamma, theta, vega and rho\) in an ordered dictionary.

## Details {#details}

Calculate vanilla option prices using specified methods.

**Return value**:

-   When *mode*=0, return a FLOATING scalar or vector indicating the NPV.
-   When *mode*=1, return a tuple with two tuple elements, NPV and Greeks \(delta, gamma, theta, vega and rho\).
-   When *mode*=2, return an ordered dictionary with keys 'npv', 'delta', 'gamma', 'theta', 'vega', and 'rho'.

## Examples {#examples}

``` {#codeblock_npt_q5x_gdc}
settlement = 1998.05.17
maturity = 1999.05.17
valDay = 1998.05.15
spot = 36
strike = 40
riskFree = 0.06
dividend = 0
volatility = 0.2
isCall = false
style = 'european'
basis = 3
calendar = 'CCFX'

vanillaOption(settlement, maturity, valDay, spot, strike, riskFree, dividend, volatility, isCall, style, basis, calendar, mode=2)

/* output:
npv->3.844299590004929
delta->-0.550451634430198
gamma->0.054964980970804
theta->-0.005058800993712
vega->14.246923067632348
rho->-23.660558429492027
*/
```

