# valueChanged {#valuechanged}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`valueChanged(X, [mode="prev"])`

## Arguments {#arguments}

**X** is a vector/matrix/table/tuple of STRING, BOOL, temporal or numeric type.

**mode** \(optional\) is a string. It can take the value of "prev", "next", "either" and "both". The default value is "prev".

-   "prev": the previous element

-   "next": the next element

-   "either": the previous OR the next element

-   "both": the previous AND the next element


## Details {#details}

Compare each element in *X* with the element specified by mode. Return true if the value is changed, otherwise false. Return false if the compared object does not exist.

For example, for the first element of `valueChanged(X, [mode="prev"])` and the last element of `valueChanged(X, [mode="next"])`, the function returns false.

If *X* is a matrix/table, perform the aforementioned operation on each column and return a matrix/table.

## Examples {#examples}

```
x= 1 2 2 2 2 3 NULL 3 4 8
valueChanged(x)
// output: [false,true,false,false,false,true,true,true,true,true]

valueChanged(x,"next")
// output: [true,false,false,false,true,true,true,true,true,false]

valueChanged(x,"either")
// output: [true,true,false,false,true,true,true,true,true,true]

valueChanged(x,"both")
// output: [false,false,false,false,false,true,true,true,true,false]

tup=(1 2 3, `A`A`B, 2021.10.12+1 2 2)
valueChanged(tup)
// output: ([false,true,true],[false,false,true],[false,true,false])

m=matrix(1 2 3, 1 2 3, 1 3 3)
valueChanged(m)
```

|col1|col2|col3|
|----|----|----|
|false|false|false|
|true|true|true|
|true|true|false|

```
id= 1 2 2 2 2 3 3 4 8
sym=`A + string(1 2 2 2 2 3 3 4 8)
val=83.8 92.8 8.1 61.4 40.7 67.2 15.2 20.6 96.5
t=table(id, sym, val)
valueChanged(t)
```

|id|sym|val|
|---|---|---|
|false|false|false|
|true|true|true|
|false|false|true|
|false|false|true|
|false|false|true|
|true|true|true|
|false|false|true|
|true|true|true|
|true|true|true|

Related function: [keys](../k/keys.md)

