# valueAtRisk {#valueAtRisk}

## Syntax {#Syntax .section}

`valueAtRisk(returns, method, [confidenceLevel=0.95])`

Alias: `VaR`

## Arguments {#Arguments .section}

**returns** is a numeric vector representing the returns. The element must be greater than -1 and cannot be empty.

**method** is a string indicating the VaR calculation method, which can be:

-   'normal': parametric method with normal distribution
-   'logNormal': parametric method with log-normal distribution
-   'historical': historical method
-   'monteCarlo': Monte Carlo simulation

**confidenceLevel** \(optional\) is a numeric scalar representing the confidence level, with a valid range of \(0,1\). The default value is 0.95.

## Details {#Details .section}

Calculate Value at Risk \(VaR\) to predict the minimum return within a given confidence level \(e.g. 95% or 99%\) over a specific time frame.

**Return value**: a DOUBLE value indicating the absolute value of the minimum return.

## Examples {#Examples .section}

Calculate VaR using historical method at a confidence level of 0.9 based on given returns:

``` {#codeblock_y33_w3z_2bc}
returns = [0.0, -0.0023816107391389394, -0.0028351258634076834, 0.00789570628538656, 0.0022056267475062397, -0.004515475812603498, 0.0031189325339843646, 0.010774648811452205, 0.0030816164453268957, 0.02172541561228001, 0.011106185767699728, -0.005369098699244845, -0.0096490689793588, 0.0025152212699484314, 0.017822140037111668, -0.02837536728283525, 0.018373545076599204, -0.0026401111537113003, 0.019524374522517898, -0.010800546314337627, 0.014073362622486131, -0.00398277532382243, 0.008398647051501285, 0.0024056749358184904, 0.007093080335863512, -0.005332549248384733, -0.008471915938733665, -0.0038788486165083342, -0.01308504169086584, 0.00350496242864784, 0.009036118926745962, 0.0013358223875250545, 0.0036426642608267563, 0.003974568474545581, -0.003944066366522669, -0.011969668605022311, 0.015116930499066374, 0.006931427295653037, -0.0032650627551519267, 0.003407880132851648]
valueAtRisk(returns, 'historical', 0.9);
//output: 0.009764216712
```

**Parent topic:**[Functions](../../Functions/category.md)

