# useOrcaStreamEngine {#useOrcaStreamEngine}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`useOrcaStreamEngine(name, func, args...)`

## Arguments {#arguments}

**name** is a string representing the name of the streaming egine. You can provide either the fully qualified name \(FQN\), such as "catalog\_name.orca\_engine.engine\_name", or just the engine name, like "engine\_name". If only the name is given, the system will automatically complete it using the current catalog.

**func**is a function to be executed on the node where the stream engine resides. This function must take at least one parameter; the system will automatically pass the stream engine object as the first argument.

**args...** are additional arguments to be passed to `func`, similar to how arguments are passed in remote procedure calls \([rpc](../r/rpc.md)\).

## Details {#details}

This function locates the node where the specified orca stream engine is running, retrieves the stream engine object, and passes it as the first argument to the user-defined function *func*for execution.

This mechanism allows users to remotely invoke various stream engine operations from local machine, without needing to manually manage the bindings between nodes and stream engines.

## Examples {#examples}

Check the status of the orca reactive state engine test.orca\_engine.rse using the `getStreamEngineStateTable` function:

``` {#codeblock_zq1_tms_c2c}
if (!existsCatalog("test")) {
	createCatalog("test")
}
go;
use catalog test

t = table(1..100 as id, 1..100 as value, take(09:29:00.000..13:00:00.000, 100) as timestamp)
g = createStreamGraph("factor")
baseStream = g.source("snapshot",  1024:0, schema(t).colDefs.name, schema(t).colDefs.typeString)
  .reactiveStateEngine([<ema(value, 100)>, <timestamp>])
  .setEngineName("rse")
  .buffer("end")
  
g.submit()
useOrcaStreamEngine("test.orca_engine.rse", getStreamEngineStateTable)

 /*
 value ema(value, 100) timestamp
----- --------------- ---------
*/
```

**Related function:** [getOrcaStreamEngineMeta](../g/getOrcaStreamEngineMeta.md)

