# updateRule {#updaterule}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`updateRule(engineName, key, rules, [add=false])`

## Arguments {#arguments}

**engineName**is a STRING scalar indicating the engine name.

**key**is a scalar of STRING or INT type that specifies the key of rule set to be updated.

**rules**is a tuple of metacode indicating the rules to be updated.

**add** \(optional\) is a boolean scalar that indicates whether the update operation should append to or overwrite the existing rules. The default value is false, meaning the existing rules will be overwritten.

## Details {#details}

This function updates the rule set associated with the specified key in the rule engine:

-   If the specified *key*does not exist in the rule engine, add the *rules*.

-   If the *key*already exists in the rule engine:

    -   If *add* is false, the existing rule set is replaced with the *rules*.

    -   If *add* is true, the *rules* is appended to the existing rule set.


**Return value**: true if successful, otherwise false.

## Examples {#examples}

```python
// create a rule engine
x = [1, 2, NULL]
y = [ [ < value>1 > ], [ < price<2 >, < price>6 > ], [ < value*price>10 > ] ]
ruleSets = dict(x, y)
names = `sym`value`price`quatity
types = [INT, DOUBLE, DOUBLE, DOUBLE]
dummy = table(10:0, names, types)
outputNames = `sym`value`price`rule
outputTypes = [INT, DOUBLE, DOUBLE, BOOL[]]
outputTable = table(10:0, outputNames, outputTypes)
test = createRuleEngine("ruleEngineTest",ruleSets,dummy ,`sym`value`price, outputTable,  "all",`sym)

test.append!(table(1 as sym, 0 as value, 2 as price, 3 as quatity))
test.append!(table(3 as sym, 6 as value, 1 as price, 3 as quatity))
/* outputTable:
1	0	2	[false]
3	6	1	[false]
*/

// modify the rule for sym=1 to value >=0
updateRule("ruleEngineTest", 1, [ <value >= 0>])
test.append!(table(1 as sym, 0 as value, 2 as price, 3 as quatity))
/* outputTable:
1	0	2	[true]
*/

// add the rule value > 5 for sym=3  
updateRule("ruleEngineTest",3,[<value>5>])
test.append!(table(3 as sym, 6 as value, 1 as price, 3 as quatity))
/* outputTable:
3	6	1	[true]
*/


// create a rule engine
x = [1, 2, NULL]
y = [ [ < value>1 > ], [ < price<2 >, < price>6 > ], [ < value*price>10 > ] ]
ruleSets = dict(x, y)
names = `sym`value`price`quatity
types = [INT, DOUBLE, DOUBLE, DOUBLE]
dummy = table(10:0, names, types)
outputNames = `sym`value`price`rule
outputTypes = [INT, DOUBLE, DOUBLE, BOOL[]]
outputTable = table(10:0, outputNames, outputTypes)
test = createRuleEngine("ruleEngineTest",ruleSets,dummy ,`sym`value`price, outputTable,  "all",`sym)

test.append!(table(1 as sym, 0 as value, 2 as price, 3 as quatity))
test.append!(table(3 as sym, 6 as value, 1 as price, 3 as quatity))
/* outputTable:
1	0	2	[false]
3	6	1	[false]
*/

// modify the rule for sym=1 to value >=0
updateRule("ruleEngineTest", 1, [ <value >= 0>])
test.append!(table(1 as sym, 0 as value, 2 as price, 3 as quatity))
/* outputTable:
1	0	2	[true]
*/

// add the rule value > 5 for sym=3  
updateRule("ruleEngineTest",3,[<value>5>])
test.append!(table(3 as sym, 6 as value, 1 as price, 3 as quatity))
/* outputTable:
3	6	1	[true]
*/

// add the rule value < 5 to the existing rule set for sym=1
updateRule(engineName="ruleEngineTest", key=1, rules=[<value<5>], add=true)
test.append!(table(1 as sym, 12 as value, 1 as price, 3 as quatity))
/* outputTable:
1   12    1     [1,0]
*/
```

