# updateMarketHoliday {#updatemarketholiday}

## Syntax {#section_r4f_clv_bzb .section}

`updateMarketHoliday(marketName, holiday)`

## Arguments {#section_w51_dlv_bzb .section}

**marketName** is a STRING scalar, indicating the identifier of the trading calendar, e.g., the Market Identifier Code of an exchange, or a user-defined calendar name.

**holiday** is a vector of DATE type, indicating weekday holidays.

**holiday** is a vector of DATE type, indicating holiday dates or trading dates.

-   If the calendar uses holiday dates, *holiday* should be specified as the dates of weekday holidays.

-   If the calendar uses trading dates, *holiday* should be specified as trading dates.


## Details {#section_sfb_2lv_bzb .section}

Updates file of holiday dates or trading datesthe holiday calendar named *marketName* in memory online and synchronizes updates to the file in *marketHolidayDir*. If the file does not exist in memory, an error will be reported.

**Note:**

-   It can only be executed by an administrator.

-   It only takes effect on the current node. In a cluster, `pnodeRun` can be used to call this function on all data/compute nodes.

-   If you have manually modified the trading calendar under *marketHolidayDir* and want to synchronize updates to memory without restarting the server, you can use function `loadText` to load the updated CSV file to an in-memory table and convert it to a vector \(holiday\), then update the holiday to memory by `updateMarketHoliday`.


## Examples {#section_ajv_2lv_bzb .section}

``` {#codeblock_txz_klv_bzb}
addMarketHoliday("CFFEX",2022.01.03 2022.01.05)
temporalAdd(2022.01.01,1,"CFFEX")
// output: 2022.01.04

index = [2022.01.01, 2022.01.02, 2022.01.03, 2022.01.04]
s = indexedSeries(index, 1..4)
s.resample("CFFEX", sum);
```

|label|col1|
|-----|----|
|2021.12.31|6|
|2022.01.04|4|

``` {#codeblock_vxz_klv_bzb}
updateMarketHoliday("CFFEX",2022.01.03 2022.01.04)
temporalAdd(2022.01.01,1,"CFFEX")
// output: 2022.01.05
```

Related functions: [addMarketHoliday](../a/addMarketHoliday.md), [getMarketCalendar](../g/getMarketCalendar.md)

