# unsubscribeStreamingSQL {#unsubscribeStreamingSQL}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`unsubscribeStreamingSQL([server], queryId)`

## Arguments {#arguments}

**server** \(optional\) A STRING scalar representing the alias or remote connection handle of the node running streaming SQL query \(i.e., the server where the query was registered\). If not specified or an empty string, the server hosting the query is the local instance.

**queryId** A STRING scalar representing the ID name for the streaming SQL query to unsubscribe.

## Details {#details}

Unsubscribe from the results of a specified streaming SQL query. After unsubscribing, the subscriber's real-time result table stops updating.

**Return value**: None.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
t=table(1..10 as id,rand(100,10) as val)
share t as st
declareStreamingSQLTable(st)
registerStreamingSQL("select avg(val) from st","sql_avg") 

subscribeStreamingSQL(queryId="sql_avg")
// output: 52.1

unsubscribeStreamingSQL(queryId="sql_avg")
```

**Related functions:** [declareStreamingSQLTable](../d/declareStreamingSQLTable.md), [registerStreamingSQL](../r/registerStreamingSQL.md), [subscribeStreamingSQL](../s/subscribeStreamingSQL.md)

