# unifiedExpr {#unifiedexpr}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`unifiedExpr(objs, optrs)`

## Arguments {#arguments}

**objs** is a tuple with no less than 2 elements.with a length between 2 and 1024 \(inclusive\).

**optrs** is a vector of binary operators and the length is size\(objs\)-1.

## Details {#details}

Connect the operands in *objs* with the binary operators in *optrs* to generate metacode of a multivariate expression. You can execute the metacode with function [eval](../e/eval.md).

## Examples {#examples}

```
unifiedExpr((1, 2), add)
// output: <1 + 2>

t=table(1..3 as price1, 4..6 as price2, 5..7 as price3)
a=sqlColAlias(unifiedExpr((sqlCol("price1"), sqlCol("price2"), sqlCol("price3")), take(add, 2)))
sql(select=(sqlCol(`price1),sqlCol(`price2),sqlCol(`price3),a), from=t).eval()
```

|price1|price2|price3|price1\_add|
|------|------|------|-----------|
|1|4|5|10|
|2|5|6|13|
|3|6|7|16|

Related function: [binaryExpr](../b/binaryExpr.md)

