# ungroup {#ungroup}

## Syntax {#section_jn3_zwp_bzb .section}

`ungroup(X)`

## Arguments {#section_vgt_zwp_bzb .section}

**X** must be a table object.

## Details {#section_cbf_1xp_bzb .section}

For table *X*, where some columns are array vectors or columnar tuples, returns the normalized table, with one row for each element of the flattened array vector or columnar tuple.

If *X* does not contain array vectors or columnar tuples or the number of rows for *X* is 0, returns *X* directly.

## Examples {#section_fks_1xp_bzb .section}

``` {#codeblock_jrw_dxp_bzb}
x = array(INT[], 0).append!([1 2 3, 4 5, 6 7 8, 9 10])
t = table(1 2 3 4 as id, x as vol)
ungroup(t)

/* output:
id vol
-- -------
1  1
1  2
1  3
2  4
2  5
3  6
3  7
3  8
4  9
4  10  
*/

// create a table where the column price is a columnar tuple
sym = `st1`st2`st3
price = [[3.1,2.5,2.8], [3.1,3.3], [3.2,2.9,3.3]]
price.setColumnarTuple!()
t = table(sym, price)
ungroup(t)
```

|sym|price|
|---|-----|
|st1|\[3.1000,2.5000,2.8000\]|
|st2|\[3.1000,3.3000\]|
|st3|\[3.2000,2.9000,3.3000\]|

``` {#codeblock_lrw_dxp_bzb}
ungroup(t)
```

|sym|price|
|---|-----|
|st1|3.1|
|st1|2.5|
|st1|2.8|
|st2|3.1|
|st2|3.3|
|st3|3.2|
|st3|2.9|
|st3|3.3|

``` {#codeblock_nrw_dxp_bzb}
sym = `st1`st2`st2`st1`st3`st1`st3`st2`st3
volume = 106 115 121 90 130 150 145 123 155;
t = table(sym, volume);
t;

t1 = select toArray(volume) as volume_all from t group by sym;
t1;
```

|sym|volume\_all|
|---|-----------|
|st1|\[106,90,150\]|
|st2|\[115,121,123\]|
|st3|\[130,145,155\]|

``` {#codeblock_prw_dxp_bzb}
ungroup(t1)
```

|sym|volume\_all|
|---|-----------|
|st1|106|
|st1|90|
|st1|150|
|st2|115|
|st2|121|
|st2|123|
|st3|130|
|st3|145|
|st3|155|

**Parent topic:**[Functions](../../Functions/category.md)

