# undef {#undef}

## Syntax {#syntax}

`undef(obj, [objType=VAR])`

or

`undef all`

## Arguments {#arguments}

**obj** is a string or a string vector indicating the names of objects to be undefined. To undefine all the variables in a category, use the unquoted "all" for *obj*.

**objType** \(optional\) is type of objects to be undefined. The types can be: VAR \(variable\), SHARED \(shared variable\) or DEF \(function definition\). The default value is VAR.

To delete all user-defined objects in the system except shared variables, use "undef all".

## Details {#details}

Release variables or function definitions from the memory. You can also release a local variable \(VAR\) from the memory using "= NULL".

## Examples {#examples}

```
undef all;
x=1
undef(`x);
x=1
y=2
undef(`x`y);
share table(1..3 as x, 4..6 as y) as t
undef(`t, SHARED);
```

```
def f(a){return a+1}
undef(`f, DEF);
a=1
b=2
undef all, VAR;
```

