# truncate {#truncate}

## Syntax {#syntax}

`truncate(dbUrl, tableName)`

## Arguments {#arguments}

**dbUrl** is a string indicating the DFS path of a database.

**tableName** is a string indicating the table name.

## Details {#details}

Remove all rows from a DFS table but keep its schema. Command `truncate` is faster than the [delete](../../Programming/SQLStatements/delete.md) statement and the [dropPartition](../d/dropPartition.md) function.

It is suggested to call function [dropTable](../d/dropTable.md) if you want to delete the schema of the table.

## Example {#example}

```
n=1000000
ID=rand(150, n)
dates=2017.08.07..2017.08.11
date=rand(dates, n)
x=rand(10.0, n)
t=table(ID, date, x)
dbDate = database(, VALUE, 2017.08.07..2017.08.11)
dbID = database(, RANGE, 0 50 100 150)

dbName="dfs://compoDB"
if(existsDatabase(dbName)){

      dropDatabase(dbName)
}
db = database(dbName, COMPO, [dbDate, dbID])
pt = db.createPartitionedTable(t, `pt, `date`ID)
pt.append!(t);

truncate(dbName, `pt)
```

